/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import com.google.protobuf.MessageLite;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import org.axonframework.axonserver.connector.util.GrpcMessageSizeExceededException;
import org.axonframework.axonserver.connector.util.GrpcMessageSizeWarningThresholdReachedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcMessageSizeInterceptor
implements ClientInterceptor {
    private final Logger logger = LoggerFactory.getLogger(GrpcMessageSizeInterceptor.class);
    private final int maxMessageSizeWarningPercentage;
    private final int maxMessageSizeInBytes;
    private final int maxMessageSizeWarningInBytes;

    public GrpcMessageSizeInterceptor(int maxMessageSizeInBytes, double maxMessageSizeWarningPercentage) {
        this.maxMessageSizeInBytes = maxMessageSizeInBytes;
        this.maxMessageSizeWarningPercentage = (int)(maxMessageSizeWarningPercentage * 100.0);
        this.maxMessageSizeWarningInBytes = (int)Math.ceil((double)maxMessageSizeInBytes * maxMessageSizeWarningPercentage);
        if (maxMessageSizeInBytes > 0x400000) {
            this.logger.info("Your outgoing Axon Server messages will be limited to {} bytes, which is greater than the default maximum of 4194304 bytes.\nMake sure the `axoniq.axonserver.max-message-size` property is set to at least {} to prevent issues such as connection instability.", (Object)maxMessageSizeInBytes, (Object)maxMessageSizeInBytes);
        }
    }

    public <REQ, RESP> ClientCall<REQ, RESP> interceptCall(MethodDescriptor<REQ, RESP> methodDescriptor, CallOptions callOptions, Channel channel) {
        ClientCall call = channel.newCall(methodDescriptor, callOptions);
        return new ForwardingClientCall.SimpleForwardingClientCall<REQ, RESP>(call){

            public void sendMessage(REQ message) {
                if (message instanceof MessageLite) {
                    int messageLength = ((MessageLite)message).getSerializedSize();
                    if (GrpcMessageSizeInterceptor.this.logger.isDebugEnabled()) {
                        GrpcMessageSizeInterceptor.this.logger.debug("Sending outbound gRPC message {} with size {}", (Object)messageLength, (Object)message.getClass().getName());
                    }
                    if (messageLength > GrpcMessageSizeInterceptor.this.maxMessageSizeInBytes) {
                        throw new GrpcMessageSizeExceededException(String.format("Message size for %s exceeds the maximum allowed size. \nActual size: %d, Maximum size: %d", message.getClass().getName(), messageLength, GrpcMessageSizeInterceptor.this.maxMessageSizeWarningInBytes));
                    }
                    if (messageLength > GrpcMessageSizeInterceptor.this.maxMessageSizeWarningInBytes) {
                        GrpcMessageSizeInterceptor.this.logger.warn("Outbound gRPC message of type {} exceeds {}% of the maximum allowed size. \nIncrease the max-message-size on both your Axon Framework application and Axon Server to allow for larger messages. \nActual size: {}, Maximum size: {}", new Object[]{message.getClass().getName(), GrpcMessageSizeInterceptor.this.maxMessageSizeWarningPercentage, messageLength, GrpcMessageSizeInterceptor.this.maxMessageSizeInBytes, new GrpcMessageSizeWarningThresholdReachedException()});
                    }
                }
                super.sendMessage(message);
            }

            public void start(ClientCall.Listener<RESP> responseListener, Metadata headers) {
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RESP>(responseListener){

                    public void onMessage(RESP message) {
                        if (message instanceof MessageLite) {
                            int messageLength = ((MessageLite)message).getSerializedSize();
                            if (GrpcMessageSizeInterceptor.this.logger.isDebugEnabled()) {
                                GrpcMessageSizeInterceptor.this.logger.debug("Received inbound gRPC message {} with size {}", (Object)messageLength, (Object)message.getClass().getName());
                            }
                            if (messageLength > GrpcMessageSizeInterceptor.this.maxMessageSizeWarningInBytes) {
                                GrpcMessageSizeInterceptor.this.logger.warn("Inbound gRPC message of type {} exceeds {}% of the maximum allowed size. \nIncrease the max-message-size on both your Axon Framework application and Axon Server to allow for larger messages. \nActual size: {}, Maximum size: {}", new Object[]{message.getClass().getName(), GrpcMessageSizeInterceptor.this.maxMessageSizeWarningPercentage, messageLength, GrpcMessageSizeInterceptor.this.maxMessageSizeInBytes, new GrpcMessageSizeWarningThresholdReachedException()});
                            }
                        }
                        super.onMessage(message);
                    }
                }, headers);
            }
        };
    }
}

