/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query.subscription;

import io.axoniq.axonserver.grpc.query.QueryUpdate;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.util.GrpcMetaData;
import org.axonframework.axonserver.connector.util.GrpcSerializedObject;
import org.axonframework.messaging.IllegalPayloadAccessException;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

class GrpcBackedQueryUpdateMessage
implements SubscriptionQueryUpdateMessage {
    private final QueryUpdate queryUpdate;
    private final LazyDeserializingObject<?> serializedPayload;
    private final Throwable exception;
    private final Supplier<MetaData> metaDataSupplier;
    private final MessageType type;

    public GrpcBackedQueryUpdateMessage(QueryUpdate queryUpdate, Serializer serializer) {
        this.queryUpdate = queryUpdate;
        this.serializedPayload = queryUpdate.hasPayload() ? new LazyDeserializingObject((SerializedObject)new GrpcSerializedObject(queryUpdate.getPayload()), serializer) : null;
        Supplier<Object> exceptionDetails = this.serializedPayload == null ? () -> null : () -> this.serializedPayload.getObject();
        this.exception = queryUpdate.hasErrorMessage() ? ErrorCode.getFromCode(queryUpdate.getErrorCode()).convert(queryUpdate.getErrorMessage(), exceptionDetails) : null;
        this.metaDataSupplier = new GrpcMetaData(queryUpdate.getMetaDataMap(), serializer);
        this.type = this.serializedPayload != null ? new MessageType(serializer.classForType(new GrpcSerializedObject(queryUpdate.getPayload()).getType())) : new MessageType(queryUpdate.getErrorCode());
    }

    private GrpcBackedQueryUpdateMessage(QueryUpdate queryUpdate, LazyDeserializingObject<?> serializedPayload, Throwable exception, Supplier<MetaData> metaDataSupplier, MessageType type) {
        this.queryUpdate = queryUpdate;
        this.serializedPayload = serializedPayload;
        this.exception = exception;
        this.metaDataSupplier = metaDataSupplier;
        this.type = type;
    }

    @Nonnull
    public String identifier() {
        return this.queryUpdate.getMessageIdentifier();
    }

    @Nonnull
    public MessageType type() {
        return this.type;
    }

    @Nonnull
    public MetaData metaData() {
        return this.metaDataSupplier.get();
    }

    @Nullable
    public Object payload() {
        if (this.isExceptional()) {
            throw new IllegalPayloadAccessException("This result completed exceptionally, payload is not available. Try calling 'exceptionResult' to see the cause of failure.", this.exception);
        }
        return this.serializedPayload == null ? null : this.serializedPayload.getObject();
    }

    @Nullable
    public <T> T payloadAs(@Nonnull Type type, @Nullable Converter converter) {
        return null;
    }

    @Nonnull
    public Class<?> payloadType() {
        return this.serializedPayload.getType();
    }

    public boolean isExceptional() {
        return this.exception != null;
    }

    public Optional<Throwable> optionalExceptionResult() {
        return Optional.ofNullable(this.exception);
    }

    @Nonnull
    public GrpcBackedQueryUpdateMessage withMetaData(@Nonnull Map<String, String> metaData) {
        return new GrpcBackedQueryUpdateMessage(this.queryUpdate, this.serializedPayload, this.exception, () -> MetaData.from((Map)metaData), this.type);
    }

    @Nonnull
    public GrpcBackedQueryUpdateMessage andMetaData(@Nonnull Map<String, String> metaData) {
        return this.withMetaData((Map)this.metaData().mergedWith(metaData));
    }

    @Nonnull
    public SubscriptionQueryUpdateMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        return null;
    }
}

