/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import io.axoniq.axonserver.grpc.query.QueryResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.util.GrpcMetaData;
import org.axonframework.axonserver.connector.util.GrpcSerializedObject;
import org.axonframework.messaging.IllegalPayloadAccessException;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;

public class GrpcBackedResponseMessage<R>
implements QueryResponseMessage {
    private final QueryResponse queryResponse;
    private final LazyDeserializingObject<R> serializedPayload;
    private final Throwable exception;
    private final Supplier<MetaData> metaDataSupplier;
    private final MessageType type;

    public GrpcBackedResponseMessage(QueryResponse queryResponse, Serializer serializer) {
        this.queryResponse = queryResponse;
        LazyDeserializingObject<R> lazyDeserializingObject = this.serializedPayload = queryResponse.hasPayload() && !SerializedType.emptyType().getName().equalsIgnoreCase(queryResponse.getPayload().getType()) ? new LazyDeserializingObject((SerializedObject)new GrpcSerializedObject(queryResponse.getPayload()), serializer) : null;
        this.exception = queryResponse.hasErrorMessage() ? ErrorCode.getFromCode(queryResponse.getErrorCode()).convert(queryResponse.getErrorMessage(), this.serializedPayload == null ? () -> null : () -> this.serializedPayload.getObject()) : null;
        this.metaDataSupplier = new GrpcMetaData(queryResponse.getMetaDataMap(), serializer);
        this.type = this.serializedPayload != null ? new MessageType(serializer.classForType(new GrpcSerializedObject(queryResponse.getPayload()).getType())) : new MessageType(queryResponse.getErrorCode());
    }

    private GrpcBackedResponseMessage(QueryResponse queryResponse, LazyDeserializingObject<R> serializedPayload, Throwable exception, Supplier<MetaData> metaDataSupplier, MessageType type) {
        this.queryResponse = queryResponse;
        this.serializedPayload = serializedPayload;
        this.exception = exception;
        this.metaDataSupplier = metaDataSupplier;
        this.type = type;
    }

    @Nonnull
    public String identifier() {
        return this.queryResponse.getMessageIdentifier();
    }

    @Nonnull
    public MessageType type() {
        return this.type;
    }

    @Nonnull
    public MetaData metaData() {
        return this.metaDataSupplier.get();
    }

    @Nullable
    public R payload() {
        if (this.isExceptional()) {
            throw new IllegalPayloadAccessException("This result completed exceptionally, payload is not available. Try calling 'exceptionResult' to see the cause of failure.", this.exception);
        }
        return (R)(this.serializedPayload == null ? null : this.serializedPayload.getObject());
    }

    @Nullable
    public <T> T payloadAs(@Nonnull Type type, @Nullable Converter converter) {
        return null;
    }

    @Nonnull
    public Class<R> payloadType() {
        return this.serializedPayload == null ? null : this.serializedPayload.getType();
    }

    public boolean isExceptional() {
        return this.exception != null;
    }

    public Optional<Throwable> optionalExceptionResult() {
        return Optional.ofNullable(this.exception);
    }

    @Nonnull
    public GrpcBackedResponseMessage<R> withMetaData(@Nonnull Map<String, String> metaData) {
        return new GrpcBackedResponseMessage<R>(this.queryResponse, this.serializedPayload, this.exception, () -> MetaData.from((Map)metaData), this.type);
    }

    @Nonnull
    public GrpcBackedResponseMessage<R> andMetaData(@Nonnull Map<String, String> metaData) {
        return this.withMetaData((Map)this.metaData().mergedWith(metaData));
    }

    @Nonnull
    public QueryResponseMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        return null;
    }
}

