/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event.util;

import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import org.axonframework.axonserver.connector.ErrorCode;

public class GrpcExceptionParser {
    private static final Metadata.Key<String> ERROR_CODE_KEY = Metadata.Key.of((String)"AxonIQ-ErrorCode", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public static RuntimeException parse(Throwable exception) {
        String code = "AXONIQ-0001";
        if (exception instanceof StatusRuntimeException) {
            String errorCode;
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)exception;
            if (Status.Code.UNIMPLEMENTED.equals((Object)statusRuntimeException.getStatus().getCode())) {
                return new UnsupportedOperationException(exception.getMessage(), exception);
            }
            Metadata trailer = statusRuntimeException.getTrailers();
            String string = errorCode = trailer == null ? null : (String)trailer.get(ERROR_CODE_KEY);
            if (errorCode != null) {
                code = errorCode;
            }
        }
        return ErrorCode.getFromCode(code).convert(exception);
    }
}

