/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.grpc.event.dcb.Event;
import io.axoniq.axonserver.grpc.event.dcb.Tag;
import io.axoniq.axonserver.grpc.event.dcb.TaggedEvent;
import jakarta.annotation.Nonnull;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.conversion.EventConverter;
import org.axonframework.eventsourcing.eventstore.TaggedEventMessage;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.Converter;

@Internal
public class TaggedEventConverter
implements DescribableComponent {
    private final EventConverter converter;

    public TaggedEventConverter(@Nonnull EventConverter converter) {
        this.converter = Objects.requireNonNull(converter, "The EventConverter cannot be null.");
    }

    public TaggedEvent convertTaggedEventMessage(@Nonnull TaggedEventMessage<?> taggedEvent) {
        return TaggedEvent.newBuilder().setEvent(this.convertEventMessage(taggedEvent.event())).addAllTag(TaggedEventConverter.convertTags(taggedEvent.tags())).build();
    }

    private Event convertEventMessage(EventMessage eventMessage) {
        return Event.newBuilder().setIdentifier(eventMessage.identifier()).setTimestamp(eventMessage.timestamp().toEpochMilli()).setName(eventMessage.type().name()).setVersion(eventMessage.type().version()).setPayload(this.convertPayload(eventMessage)).putAllMetadata(this.convertMetaData(eventMessage.metaData())).build();
    }

    private ByteString convertPayload(EventMessage payload) {
        byte[] bytes = (byte[])payload.payloadAs(byte[].class, (Converter)this.converter);
        return bytes == null || bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes);
    }

    private Map<String, String> convertMetaData(MetaData metaData) {
        return metaData.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static List<Tag> convertTags(Set<org.axonframework.eventstreaming.Tag> tags) {
        return tags.stream().map(TaggedEventConverter::convertTag).collect(Collectors.toList());
    }

    private static Tag convertTag(org.axonframework.eventstreaming.Tag tag) {
        return Tag.newBuilder().setKey(TaggedEventConverter.convertString(tag.key())).setValue(TaggedEventConverter.convertString(tag.value())).build();
    }

    private static ByteString convertString(String s) {
        return ByteString.copyFrom((String)s, (Charset)StandardCharsets.UTF_8);
    }

    public EventMessage convertEvent(@Nonnull Event event) {
        return new GenericEventMessage(event.getIdentifier(), new MessageType(event.getName(), event.getVersion()), (Object)event.getPayload().toByteArray(), event.getMetadataMap(), Instant.ofEpochMilli(event.getTimestamp()));
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("converter", (Object)this.converter);
    }
}

