/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.command;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.ProcessingInstruction;
import io.axoniq.axonserver.grpc.ProcessingKey;
import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.command.Command;
import io.axoniq.axonserver.grpc.command.CommandResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.MetaDataConverter;
import org.axonframework.axonserver.connector.util.ProcessingInstructionHelper;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.common.AxonException;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.annotation.Internal;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;

@Internal
public class CommandConverter {
    private CommandConverter() {
    }

    public static Command convertCommandMessage(@Nonnull CommandMessage command, @Nonnull String clientId, @Nonnull String componentName) {
        Object payload = command.payload();
        if (!(payload instanceof byte[])) {
            throw new IllegalArgumentException("Payload must be of type byte[] for AxonServerConnector, but was: " + command.payloadType().getName() + ", consider using a Converter-based CommandBusConnector");
        }
        byte[] payloadAsBytes = (byte[])payload;
        Command.Builder builder = Command.newBuilder();
        CommandConverter.addRoutingKey(builder, command);
        CommandConverter.addPriority(builder, command);
        return builder.setClientId(clientId).setComponentName(componentName).setMessageIdentifier(command.identifier()).setName(command.type().name()).putAllMetaData(MetaDataConverter.convertGrpcToMetaDataValues((Map<String, String>)command.metaData())).setPayload(SerializedObject.newBuilder().setData(ByteString.copyFrom((byte[])payloadAsBytes)).setType(command.type().name()).setRevision(command.type().version()).build()).build();
    }

    private static void addRoutingKey(Command.Builder builder, CommandMessage command) {
        Optional routingKey = command.routingKey();
        if (routingKey.isEmpty()) {
            return;
        }
        ProcessingInstruction.Builder instruction = ProcessingInstructionHelper.createProcessingInstruction(ProcessingKey.ROUTING_KEY, MetaDataValue.newBuilder().setTextValue((String)routingKey.get()));
        builder.addProcessingInstructions(instruction).build();
    }

    private static void addPriority(Command.Builder builder, CommandMessage command) {
        OptionalInt priority = command.priority();
        if (priority.isEmpty()) {
            return;
        }
        ProcessingInstruction.Builder instruction = ProcessingInstructionHelper.createProcessingInstruction(ProcessingKey.PRIORITY, MetaDataValue.newBuilder().setNumberValue((long)priority.getAsInt()));
        builder.addProcessingInstructions(instruction).build();
    }

    public static CompletableFuture<CommandResultMessage<?>> convertCommandResponse(@Nonnull CommandResponse commandResponse) {
        if (commandResponse.hasErrorMessage()) {
            return CompletableFuture.failedFuture((Throwable)CommandConverter.exceptionFromErrorResponse(commandResponse));
        }
        if (commandResponse.getPayload().getType().isEmpty()) {
            return FutureUtils.emptyCompletedFuture();
        }
        MessageType messageType = new MessageType(commandResponse.getPayload().getType(), commandResponse.getPayload().getRevision());
        Map<String, String> metadata = MetaDataConverter.convertMetaDataValuesToGrpc(commandResponse.getMetaDataMap());
        return CompletableFuture.completedFuture(new GenericCommandResultMessage((Message)new GenericMessage(commandResponse.getMessageIdentifier(), messageType, (Object)commandResponse.getPayload().getData().toByteArray(), metadata)));
    }

    private static AxonException exceptionFromErrorResponse(CommandResponse commandResponse) {
        return ErrorCode.getFromCode(commandResponse.getErrorCode()).convert(commandResponse.getErrorMessage(), () -> CommandConverter.getErrorMessageFromCommandResponse(commandResponse));
    }

    private static Object getErrorMessageFromCommandResponse(CommandResponse commandResponse) {
        if (commandResponse.getPayload().getData().isEmpty()) {
            return null;
        }
        return commandResponse.getPayload().getData().toByteArray();
    }

    public static CommandMessage convertCommand(@Nonnull Command command) {
        SerializedObject commandPayload = command.getPayload();
        int priority = ProcessingInstructionHelper.priority(command.getProcessingInstructionsList());
        String routingKey = ProcessingInstructionHelper.routingKey(command.getProcessingInstructionsList());
        return new GenericCommandMessage((Message)new GenericMessage(command.getMessageIdentifier(), new MessageType(commandPayload.getType(), commandPayload.getRevision()), (Object)commandPayload.getData().toByteArray(), MetaDataConverter.convertMetaDataValuesToGrpc(command.getMetaDataMap())), routingKey, Integer.valueOf(priority));
    }

    public static CommandResponse convertResultMessage(@Nullable CommandResultMessage<?> resultMessage, @Nonnull String requestIdentifier) {
        if (resultMessage == null) {
            return CommandResponse.newBuilder().setMessageIdentifier(UUID.randomUUID().toString()).setRequestIdentifier(requestIdentifier).build();
        }
        Object payload = resultMessage.payload();
        String messageId = (String)ObjectUtils.getOrDefault((Object)resultMessage.identifier(), (Object)UUID.randomUUID().toString());
        CommandResponse.Builder responseBuilder = CommandResponse.newBuilder().setMessageIdentifier(messageId).putAllMetaData(MetaDataConverter.convertGrpcToMetaDataValues((Map<String, String>)resultMessage.metaData())).setRequestIdentifier(requestIdentifier);
        if (payload != null && !(payload instanceof byte[])) {
            throw new IllegalArgumentException("Payload must be of type byte[] for AxonServerConnector, but was: %s, consider using a Converter-based CommandBusConnector".formatted(resultMessage.payloadType().getName()));
        }
        byte[] payloadAsBytes = Objects.requireNonNullElse(payload, new byte[0]);
        return responseBuilder.setPayload(SerializedObject.newBuilder().setType(resultMessage.type().name()).setRevision(resultMessage.type().version()).setData(ByteString.copyFrom((byte[])payloadAsBytes))).build();
    }
}

