/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event.axon;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.axonframework.config.LegacyConfiguration;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.async.SequencingPolicy;

public class PersistentStreamSequencingPolicyProvider
implements Function<LegacyConfiguration, SequencingPolicy<? super EventMessage<?>>> {
    public static final String SEQUENTIAL_PER_AGGREGATE_POLICY = "SequentialPerAggregatePolicy";
    public static final String META_DATA_SEQUENCING_POLICY = "MetaDataSequencingPolicy";
    public static final String SEQUENTIAL_POLICY = "SequentialPolicy";
    public static final String FULL_CONCURRENCY_POLICY = "FullConcurrencyPolicy";
    public static final String PROPERTY_SEQUENCING_POLICY = "PropertySequencingPolicy";
    private static final String SEQUENTIAL_POLICY_IDENTIFIER = "SequentialPolicy";
    private final String name;
    private final String sequencingPolicy;
    private final List<String> sequencingPolicyParameters;

    public PersistentStreamSequencingPolicyProvider(String name, String sequencingPolicy, List<String> sequencingPolicyParameters) {
        this.name = name;
        this.sequencingPolicy = sequencingPolicy;
        this.sequencingPolicyParameters = sequencingPolicyParameters;
    }

    @Override
    public SequencingPolicy<EventMessage<?>> apply(LegacyConfiguration configuration) {
        return this::sequencingIdentifier;
    }

    private Object sequencingIdentifier(EventMessage<?> event) {
        if (SEQUENTIAL_PER_AGGREGATE_POLICY.equals(this.sequencingPolicy)) {
            if (event instanceof DomainEventMessage) {
                return ((DomainEventMessage)event).getAggregateIdentifier();
            }
            return event.getIdentifier();
        }
        if (META_DATA_SEQUENCING_POLICY.equals(this.sequencingPolicy)) {
            LinkedList<String> metaDataValues = new LinkedList<String>();
            for (String sequencingPolicyParameter : this.sequencingPolicyParameters) {
                metaDataValues.add(event.getMetaData().get((Object)sequencingPolicyParameter));
            }
            return metaDataValues;
        }
        if ("SequentialPolicy".equals(this.sequencingPolicy)) {
            return "SequentialPolicy";
        }
        if (FULL_CONCURRENCY_POLICY.equals(this.sequencingPolicy)) {
            return event.getIdentifier();
        }
        if (PROPERTY_SEQUENCING_POLICY.equals(this.sequencingPolicy)) {
            throw new RuntimeException(this.name + ": Cannot use the PropertySequencingPolicy in combination with dead-letter queue");
        }
        throw new RuntimeException(String.format("%s :Unknown sequencing policy %s in combination with dead-letter queue", this.name, this.sequencingPolicy));
    }
}

