/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.ManagedChannelCustomizer;
import org.axonframework.axonserver.connector.TagsConfiguration;
import org.axonframework.axonserver.connector.event.AxonServerEventStorageEngine;
import org.axonframework.axonserver.connector.event.AxonServerEventStorageEngineFactory;
import org.axonframework.configuration.ComponentDefinition;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.configuration.SearchScope;

public class ServerConnectorConfigurationEnhancer
implements ConfigurationEnhancer {
    public static final int ENHANCER_ORDER = -2147483638;

    public void enhance(@Nonnull ComponentRegistry registry) {
        registry.registerIfNotPresent(AxonServerConfiguration.class, c -> new AxonServerConfiguration(), SearchScope.ALL).registerIfNotPresent(this.connectionManagerDefinition(), SearchScope.ALL).registerIfNotPresent(ManagedChannelCustomizer.class, c -> ManagedChannelCustomizer.identity(), SearchScope.ALL).registerIfNotPresent(this.eventStorageEngineDefinition(), SearchScope.ALL).registerFactory((ComponentFactory)new AxonServerEventStorageEngineFactory());
    }

    private ComponentDefinition<AxonServerConnectionManager> connectionManagerDefinition() {
        return ComponentDefinition.ofType(AxonServerConnectionManager.class).withBuilder(this::buildConnectionManager).onStart(0x40000009, AxonServerConnectionManager::start).onShutdown(-134217728, AxonServerConnectionManager::shutdown);
    }

    private AxonServerConnectionManager buildConnectionManager(Configuration config) {
        AxonServerConfiguration serverConfig = (AxonServerConfiguration)config.getComponent(AxonServerConfiguration.class);
        return AxonServerConnectionManager.builder().routingServers(serverConfig.getServers()).axonServerConfiguration(serverConfig).tagsConfiguration((TagsConfiguration)config.getComponent(TagsConfiguration.class, TagsConfiguration::new)).channelCustomizer((UnaryOperator)config.getComponent(ManagedChannelCustomizer.class)).build();
    }

    private ComponentDefinition<AxonServerEventStorageEngine> eventStorageEngineDefinition() {
        return ComponentDefinition.ofType(AxonServerEventStorageEngine.class).withBuilder(config -> {
            String defaultContext = ((AxonServerConfiguration)config.getComponent(AxonServerConfiguration.class)).getContext();
            return AxonServerEventStorageEngineFactory.constructForContext(defaultContext, config);
        });
    }

    public int order() {
        return -2147483638;
    }
}

