/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event.axon;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.connector.event.EventChannel;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.event.Event;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.event.util.GrpcExceptionParser;
import org.axonframework.axonserver.connector.util.GrpcMetaDataConverter;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.StringUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.scheduling.EventScheduler;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.eventhandling.scheduling.java.SimpleScheduleToken;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.Serializer;

public class AxonServerEventScheduler
implements EventScheduler {
    private final long requestTimeout;
    private final Serializer serializer;
    private final AxonServerConnectionManager axonServerConnectionManager;
    private final GrpcMetaDataConverter converter;
    private final String context;
    private final AtomicBoolean started = new AtomicBoolean();

    public static Builder builder() {
        return new Builder();
    }

    protected AxonServerEventScheduler(Builder builder) {
        builder.validate();
        this.requestTimeout = builder.requestTimeout;
        this.serializer = builder.serializer.get();
        this.axonServerConnectionManager = builder.axonServerConnectionManager;
        this.context = builder.defaultContext;
        this.converter = new GrpcMetaDataConverter(this.serializer);
    }

    public void start() {
        this.started.set(true);
    }

    public void shutdownDispatching() {
        this.started.set(false);
    }

    public ScheduleToken schedule(Instant triggerDateTime, Object event) {
        Assert.isTrue((boolean)this.started.get(), () -> "Cannot dispatch new events as this scheduler is being shutdown");
        try {
            String response = (String)this.eventChannel().scheduleEvent(triggerDateTime, this.toEvent(event)).get(this.requestTimeout, TimeUnit.MILLISECONDS);
            return new SimpleScheduleToken(response);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw GrpcExceptionParser.parse(e);
        }
        catch (ExecutionException e) {
            throw GrpcExceptionParser.parse(e.getCause());
        }
        catch (TimeoutException e) {
            throw GrpcExceptionParser.parse(e);
        }
    }

    public ScheduleToken schedule(Duration triggerDuration, Object event) {
        return this.schedule(Instant.now().plus(triggerDuration), event);
    }

    public void cancelSchedule(ScheduleToken scheduleToken) {
        Assert.isTrue((boolean)this.started.get(), () -> "Scheduler is being shutdown");
        Assert.isTrue((boolean)(scheduleToken instanceof SimpleScheduleToken), () -> "Invalid tracking token type. Must be SimpleScheduleToken.");
        String token = ((SimpleScheduleToken)scheduleToken).getTokenId();
        try {
            InstructionAck instructionAck = (InstructionAck)this.eventChannel().cancelSchedule(token).get(this.requestTimeout, TimeUnit.MILLISECONDS);
            if (!instructionAck.getSuccess()) {
                throw ErrorCode.getFromCode(instructionAck.getError().getErrorCode()).convert(instructionAck.getError());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw GrpcExceptionParser.parse(e);
        }
        catch (ExecutionException e) {
            throw GrpcExceptionParser.parse(e.getCause());
        }
        catch (TimeoutException e) {
            throw GrpcExceptionParser.parse(e);
        }
    }

    public ScheduleToken reschedule(ScheduleToken scheduleToken, Duration triggerDuration, Object event) {
        Assert.isTrue((boolean)this.started.get(), () -> "Cannot dispatch new events as this scheduler is being shutdown");
        Assert.isTrue((scheduleToken == null || scheduleToken instanceof SimpleScheduleToken ? 1 : 0) != 0, () -> "Invalid tracking token type. Must be SimpleScheduleToken.");
        String token = scheduleToken == null ? "" : ((SimpleScheduleToken)scheduleToken).getTokenId();
        try {
            String updatedScheduleToken = (String)this.eventChannel().reschedule(token, Instant.now().plus(triggerDuration), this.toEvent(event)).get(this.requestTimeout, TimeUnit.MILLISECONDS);
            return new SimpleScheduleToken(updatedScheduleToken);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw GrpcExceptionParser.parse(e);
        }
        catch (ExecutionException e) {
            throw GrpcExceptionParser.parse(e.getCause());
        }
        catch (TimeoutException e) {
            throw GrpcExceptionParser.parse(e);
        }
    }

    private EventChannel eventChannel() {
        return StringUtils.nonEmptyOrNull((String)this.context) ? this.axonServerConnectionManager.getConnection(this.context).eventChannel() : this.axonServerConnectionManager.getConnection().eventChannel();
    }

    private Event toEvent(Object event) {
        MetaData metadata;
        org.axonframework.serialization.SerializedObject serializedPayload;
        String requestId = null;
        if (event instanceof EventMessage) {
            serializedPayload = ((EventMessage)event).serializePayload(this.serializer, byte[].class);
            metadata = ((EventMessage)event).getMetaData();
            requestId = ((EventMessage)event).getIdentifier();
        } else {
            metadata = MetaData.emptyInstance();
            serializedPayload = this.serializer.serialize(event, byte[].class);
        }
        if (requestId == null) {
            requestId = IdentifierFactory.getInstance().generateIdentifier();
        }
        Event.Builder builder = Event.newBuilder().setMessageIdentifier(requestId);
        builder.setPayload(SerializedObject.newBuilder().setType(serializedPayload.getType().getName()).setRevision((String)ObjectUtils.getOrDefault((Object)serializedPayload.getType().getRevision(), (Object)"")).setData(ByteString.copyFrom((byte[])((byte[])serializedPayload.getData()))));
        metadata.forEach((k, v) -> builder.putMetaData(k, this.converter.convertToMetaDataValue(v)));
        return builder.build();
    }

    public static class Builder {
        private long requestTimeout = 15000L;
        private Supplier<Serializer> serializer;
        private AxonServerConnectionManager axonServerConnectionManager;
        private String defaultContext;

        public Builder requestTimeout(long timeout, TimeUnit unit) {
            this.requestTimeout = unit.toMillis(timeout);
            return this;
        }

        public Builder eventSerializer(Serializer eventSerializer) {
            BuilderUtils.assertNonNull((Object)eventSerializer, (String)"The event Serializer may not be null");
            this.serializer = () -> eventSerializer;
            return this;
        }

        public Builder connectionManager(AxonServerConnectionManager axonServerConnectionManager) {
            BuilderUtils.assertNonNull((Object)axonServerConnectionManager, (String)"AxonServerConnectionManager may not be null");
            this.axonServerConnectionManager = axonServerConnectionManager;
            return this;
        }

        public Builder defaultContext(String defaultContext) {
            BuilderUtils.assertNonEmpty((String)defaultContext, (String)"The context may not be null or empty");
            this.defaultContext = defaultContext;
            return this;
        }

        public AxonServerEventScheduler build() {
            return new AxonServerEventScheduler(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.serializer, (String)"The Serializer is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.axonServerConnectionManager, (String)"The AxonServerConnectionManager is a hard requirement and should be provided");
        }
    }
}

