/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.command;

import io.axoniq.axonserver.grpc.command.Command;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.axonframework.axonserver.connector.util.GrpcMetaData;
import org.axonframework.axonserver.connector.util.GrpcSerializedObject;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class GrpcBackedCommandMessage<C>
implements CommandMessage<C> {
    private final Command command;
    private final LazyDeserializingObject<C> serializedPayload;
    private final Supplier<MetaData> metaDataSupplier;

    public GrpcBackedCommandMessage(Command command, Serializer serializer) {
        this(command, new LazyDeserializingObject((SerializedObject)new GrpcSerializedObject(command.getPayload()), serializer), new GrpcMetaData(command.getMetaDataMap(), serializer));
    }

    private GrpcBackedCommandMessage(Command command, LazyDeserializingObject<C> serializedPayload, Supplier<MetaData> metaDataSupplier) {
        this.command = command;
        this.serializedPayload = serializedPayload;
        this.metaDataSupplier = metaDataSupplier;
    }

    public String getCommandName() {
        return this.command.getName();
    }

    public String getIdentifier() {
        return this.command.getMessageIdentifier();
    }

    public MetaData getMetaData() {
        return this.metaDataSupplier.get();
    }

    public C getPayload() {
        return (C)this.serializedPayload.getObject();
    }

    public Class<C> getPayloadType() {
        return this.serializedPayload.getType();
    }

    public GrpcBackedCommandMessage<C> withMetaData(@Nonnull Map<String, ?> metaData) {
        return new GrpcBackedCommandMessage<C>(this.command, this.serializedPayload, () -> MetaData.from((Map)metaData));
    }

    public GrpcBackedCommandMessage<C> andMetaData(@Nonnull Map<String, ?> metaData) {
        return this.withMetaData((Map)this.getMetaData().mergedWith(metaData));
    }
}

