/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query.subscription;

import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.query.QueryProviderOutbound;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.grpc.query.QueryUpdate;
import io.axoniq.axonserver.grpc.query.QueryUpdateComplete;
import io.axoniq.axonserver.grpc.query.QueryUpdateCompleteExceptionally;
import io.axoniq.axonserver.grpc.query.SubscriptionQuery;
import io.axoniq.axonserver.grpc.query.SubscriptionQueryResponse;
import java.util.Map;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.query.GrpcBackedResponseMessage;
import org.axonframework.axonserver.connector.query.subscription.GrpcBackedQueryUpdateMessage;
import org.axonframework.axonserver.connector.query.subscription.GrpcBackedSubscriptionQueryMessage;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.axonserver.connector.util.GrpcMetaDataConverter;
import org.axonframework.axonserver.connector.util.GrpcMetadataSerializer;
import org.axonframework.axonserver.connector.util.GrpcObjectSerializer;
import org.axonframework.axonserver.connector.util.GrpcPayloadSerializer;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.serialization.Serializer;

public class SubscriptionMessageSerializer {
    private final AxonServerConfiguration configuration;
    private final Serializer messageSerializer;
    private final Serializer serializer;
    private final GrpcObjectSerializer<Object> exceptionDetailsSerializer;
    private final GrpcPayloadSerializer payloadSerializer;
    private final GrpcMetadataSerializer metadataSerializer;
    private final GrpcObjectSerializer<Object> responseTypeSerializer;

    public SubscriptionMessageSerializer(Serializer messageSerializer, Serializer serializer, AxonServerConfiguration configuration) {
        this.configuration = configuration;
        this.messageSerializer = messageSerializer;
        this.serializer = serializer;
        this.payloadSerializer = new GrpcPayloadSerializer(messageSerializer);
        this.metadataSerializer = new GrpcMetadataSerializer(new GrpcMetaDataConverter(messageSerializer));
        this.responseTypeSerializer = new GrpcObjectSerializer(serializer);
        this.exceptionDetailsSerializer = new GrpcObjectSerializer(messageSerializer);
    }

    public QueryRequest serializeQuery(SubscriptionQueryMessage subscriptionQueryMessage) {
        return QueryRequest.newBuilder().setTimestamp(System.currentTimeMillis()).setMessageIdentifier(subscriptionQueryMessage.getIdentifier()).setQuery(subscriptionQueryMessage.getQueryName()).setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).setPayload(this.payloadSerializer.apply((Message)subscriptionQueryMessage)).setResponseType(this.responseTypeSerializer.apply((Object)subscriptionQueryMessage.getResponseType())).putAllMetaData(this.metadataSerializer.apply(subscriptionQueryMessage.getMetaData())).build();
    }

    public SerializedObject serializeUpdateType(SubscriptionQueryMessage<?, ?, ?> subscriptionQueryMessage) {
        return this.responseTypeSerializer.apply((Object)subscriptionQueryMessage.getUpdateResponseType());
    }

    public QueryUpdate serialize(SubscriptionQueryUpdateMessage<?> subscriptionQueryUpdateMessage) {
        QueryUpdate.Builder updateMessageBuilder = QueryUpdate.newBuilder();
        if (subscriptionQueryUpdateMessage.isExceptional()) {
            Throwable exceptionResult = subscriptionQueryUpdateMessage.exceptionResult();
            updateMessageBuilder.setErrorCode(ErrorCode.QUERY_EXECUTION_ERROR.errorCode());
            updateMessageBuilder.setErrorMessage(ExceptionSerializer.serialize(this.configuration.getClientId(), exceptionResult));
            subscriptionQueryUpdateMessage.exceptionDetails().ifPresent(details -> updateMessageBuilder.setPayload(this.exceptionDetailsSerializer.apply(details)));
        } else {
            updateMessageBuilder.setPayload(this.payloadSerializer.apply((Message)subscriptionQueryUpdateMessage));
        }
        Map<String, MetaDataValue> metaData = this.metadataSerializer.apply(subscriptionQueryUpdateMessage.getMetaData());
        return updateMessageBuilder.putAllMetaData(metaData).setMessageIdentifier(subscriptionQueryUpdateMessage.getIdentifier()).setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).build();
    }

    public <Q, I, U> SubscriptionQueryMessage<Q, I, U> deserialize(SubscriptionQuery subscriptionQuery) {
        return new GrpcBackedSubscriptionQueryMessage(subscriptionQuery, this.messageSerializer, this.serializer);
    }

    public <I> QueryResponseMessage<I> deserialize(QueryResponse queryResponse) {
        return new GrpcBackedResponseMessage(queryResponse, this.messageSerializer);
    }

    public <U> SubscriptionQueryUpdateMessage<U> deserialize(QueryUpdate queryUpdate) {
        return new GrpcBackedQueryUpdateMessage(queryUpdate, this.messageSerializer);
    }

    @Deprecated
    public SubscriptionQuery serialize(SubscriptionQueryMessage<?, ?, ?> subscriptionQueryMessage) {
        QueryRequest queryRequest = QueryRequest.newBuilder().setTimestamp(System.currentTimeMillis()).setMessageIdentifier(subscriptionQueryMessage.getIdentifier()).setQuery(subscriptionQueryMessage.getQueryName()).setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).setPayload(this.payloadSerializer.apply((Message)subscriptionQueryMessage)).setResponseType(this.responseTypeSerializer.apply((Object)subscriptionQueryMessage.getResponseType())).putAllMetaData(this.metadataSerializer.apply(subscriptionQueryMessage.getMetaData())).build();
        return SubscriptionQuery.newBuilder().setSubscriptionIdentifier(subscriptionQueryMessage.getIdentifier()).setNumberOfPermits((long)this.configuration.getInitialNrOfPermits().intValue()).setUpdateResponseType(this.responseTypeSerializer.apply((Object)subscriptionQueryMessage.getUpdateResponseType())).setQueryRequest(queryRequest).build();
    }

    @Deprecated
    QueryProviderOutbound serialize(QueryResponseMessage<?> initialResult, String subscriptionId) {
        QueryResponse.Builder responseBuilder = QueryResponse.newBuilder().putAllMetaData(this.metadataSerializer.apply(initialResult.getMetaData())).setMessageIdentifier(initialResult.getIdentifier()).setRequestIdentifier(subscriptionId);
        if (initialResult.isExceptional()) {
            Throwable exceptionResult = initialResult.exceptionResult();
            responseBuilder.setErrorCode(ErrorCode.QUERY_EXECUTION_ERROR.errorCode());
            responseBuilder.setErrorMessage(ExceptionSerializer.serialize(this.configuration.getClientId(), exceptionResult));
            initialResult.exceptionDetails().ifPresent(details -> responseBuilder.setPayload(this.exceptionDetailsSerializer.apply(details)));
        } else {
            responseBuilder.setPayload(this.payloadSerializer.apply((Message)initialResult));
        }
        return QueryProviderOutbound.newBuilder().setSubscriptionQueryResponse(SubscriptionQueryResponse.newBuilder().setSubscriptionIdentifier(subscriptionId).setInitialResult(responseBuilder.build())).build();
    }

    @Deprecated
    QueryProviderOutbound serializeComplete(String subscriptionId) {
        QueryUpdateComplete completedQueryUpdate = QueryUpdateComplete.newBuilder().setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).build();
        return QueryProviderOutbound.newBuilder().setSubscriptionQueryResponse(SubscriptionQueryResponse.newBuilder().setSubscriptionIdentifier(subscriptionId).setComplete(completedQueryUpdate)).build();
    }

    @Deprecated
    QueryProviderOutbound serializeCompleteExceptionally(String subscriptionId, Throwable cause) {
        QueryUpdateCompleteExceptionally exceptionallyCompletedQueryUpdate = QueryUpdateCompleteExceptionally.newBuilder().setErrorMessage(ExceptionSerializer.serialize(this.configuration.getClientId(), cause)).setErrorCode(ErrorCode.QUERY_EXECUTION_ERROR.errorCode()).setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).build();
        return QueryProviderOutbound.newBuilder().setSubscriptionQueryResponse(SubscriptionQueryResponse.newBuilder().setSubscriptionIdentifier(subscriptionId).setCompleteExceptionally(exceptionallyCompletedQueryUpdate)).build();
    }
}

