/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event.axon;

import java.util.function.Function;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.processor.EventProcessorControlService;
import org.axonframework.axonserver.connector.processor.EventProcessorController;
import org.axonframework.axonserver.connector.processor.grpc.GrpcEventProcessorInfoSource;
import org.axonframework.axonserver.connector.processor.schedule.ScheduledEventProcessorInfoSource;
import org.axonframework.config.Component;
import org.axonframework.config.Configuration;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.config.ModuleConfiguration;

public class EventProcessorInfoConfiguration
implements ModuleConfiguration {
    private Configuration config;
    private final Component<EventProcessingConfiguration> eventProcessingConfiguration;
    private final Component<AxonServerConnectionManager> connectionManager;
    private final Component<AxonServerConfiguration> axonServerConfiguration;
    private final Component<EventProcessorControlService> eventProcessorControlService;
    private final Component<ScheduledEventProcessorInfoSource> processorInfoSource;

    public EventProcessorInfoConfiguration() {
        this(Configuration::eventProcessingConfiguration, c -> (AxonServerConnectionManager)c.getComponent(AxonServerConnectionManager.class), c -> (AxonServerConfiguration)c.getComponent(AxonServerConfiguration.class));
    }

    public EventProcessorInfoConfiguration(Function<Configuration, EventProcessingConfiguration> eventProcessingConfiguration, Function<Configuration, AxonServerConnectionManager> connectionManager, Function<Configuration, AxonServerConfiguration> axonServerConfiguration) {
        this.eventProcessingConfiguration = new Component(() -> this.config, "eventProcessingConfiguration", eventProcessingConfiguration);
        this.connectionManager = new Component(() -> this.config, "connectionManager", connectionManager);
        this.axonServerConfiguration = new Component(() -> this.config, "connectionManager", axonServerConfiguration);
        this.eventProcessorControlService = new Component(() -> this.config, "eventProcessorControlService", c -> new EventProcessorControlService((AxonServerConnectionManager)this.connectionManager.get(), new EventProcessorController((EventProcessingConfiguration)this.eventProcessingConfiguration.get())));
        this.processorInfoSource = new Component(() -> this.config, "eventProcessorInfoSource", c -> {
            GrpcEventProcessorInfoSource infoSource = new GrpcEventProcessorInfoSource((EventProcessingConfiguration)this.eventProcessingConfiguration.get(), (AxonServerConnectionManager)this.connectionManager.get(), ((AxonServerConfiguration)this.axonServerConfiguration.get()).getContext());
            return new ScheduledEventProcessorInfoSource(((AxonServerConfiguration)this.axonServerConfiguration.get()).getProcessorsNotificationInitialDelay(), ((AxonServerConfiguration)this.axonServerConfiguration.get()).getProcessorsNotificationRate(), infoSource);
        });
    }

    public void initialize(Configuration config) {
        this.config = config;
        this.config.onStart(0x3FFFFFFF, () -> {
            this.processorInfoSource.get();
            this.eventProcessorControlService.get();
        });
    }
}

