/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.processor.grpc;

import io.axoniq.axonserver.grpc.control.EventProcessorInfo;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import java.util.List;
import java.util.stream.Collectors;
import org.axonframework.axonserver.connector.processor.grpc.PlatformInboundMessage;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.TrackingEventProcessor;
import org.axonframework.eventhandling.TrackingToken;

public class TrackingEventProcessorInfoMessage
implements PlatformInboundMessage {
    private static final String EVENT_PROCESSOR_MODE = "Tracking";
    private final TrackingEventProcessor eventProcessor;

    TrackingEventProcessorInfoMessage(TrackingEventProcessor eventProcessor) {
        this.eventProcessor = eventProcessor;
    }

    @Override
    public PlatformInboundInstruction instruction() {
        List trackerInfo = this.eventProcessor.processingStatus().values().stream().map(this::buildTrackerInfo).collect(Collectors.toList());
        EventProcessorInfo eventProcessorInfo = EventProcessorInfo.newBuilder().setProcessorName(this.eventProcessor.getName()).setMode(EVENT_PROCESSOR_MODE).setActiveThreads(this.eventProcessor.activeProcessorThreads()).setAvailableThreads(this.eventProcessor.availableProcessorThreads()).setRunning(this.eventProcessor.isRunning()).setError(this.eventProcessor.isError()).addAllSegmentStatus(trackerInfo).build();
        return PlatformInboundInstruction.newBuilder().setEventProcessorInfo(eventProcessorInfo).build();
    }

    private EventProcessorInfo.SegmentStatus buildTrackerInfo(EventTrackerStatus status) {
        return EventProcessorInfo.SegmentStatus.newBuilder().setSegmentId(status.getSegment().getSegmentId()).setCaughtUp(status.isCaughtUp()).setReplaying(status.isReplaying()).setOnePartOf(status.getSegment().getMask() + 1).setTokenPosition(this.getPosition(status.getTrackingToken())).setErrorState(status.isErrorState() ? this.buildErrorMessage(status.getError()) : "").build();
    }

    private long getPosition(TrackingToken trackingToken) {
        long position = 0L;
        if (trackingToken != null) {
            position = trackingToken.position().orElse(0L);
        }
        return position;
    }

    private String buildErrorMessage(Throwable error) {
        return error.getClass().getName() + ": " + error.getMessage();
    }
}

