/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.processor.schedule;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.axonframework.axonserver.connector.processor.EventProcessorInfoSource;

public class ScheduledEventProcessorInfoSource
implements EventProcessorInfoSource {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final int initialDelay;
    private final int schedulingPeriod;
    private final EventProcessorInfoSource delegate;

    public ScheduledEventProcessorInfoSource(int initialDelay, int schedulingPeriod, EventProcessorInfoSource delegate) {
        this.initialDelay = initialDelay;
        this.schedulingPeriod = schedulingPeriod;
        this.delegate = delegate;
    }

    public void start() {
        this.scheduler.scheduleAtFixedRate(this::notifyInformation, this.initialDelay, this.schedulingPeriod, TimeUnit.MILLISECONDS);
    }

    @Override
    public void notifyInformation() {
        try {
            this.delegate.notifyInformation();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }
}

