/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import io.axoniq.axonserver.grpc.query.QueryRequest;
import java.util.Map;
import java.util.function.Supplier;
import org.axonframework.axonserver.connector.util.GrpcMetadata;
import org.axonframework.axonserver.connector.util.GrpcSerializedObject;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class GrpcBackedQueryMessage<Q, R>
implements QueryMessage<Q, R> {
    private final QueryRequest query;
    private final Serializer messageSerializer;
    private final LazyDeserializingObject<Q> serializedPayload;
    private final LazyDeserializingObject<ResponseType<R>> serializedResponseType;
    private final Supplier<MetaData> metadata;

    public GrpcBackedQueryMessage(QueryRequest query, Serializer messageSerializer, Serializer genericSerializer) {
        this.query = query;
        this.messageSerializer = messageSerializer;
        this.serializedPayload = new LazyDeserializingObject((SerializedObject)new GrpcSerializedObject(query.getPayload()), messageSerializer);
        this.serializedResponseType = new LazyDeserializingObject((SerializedObject)new GrpcSerializedObject(query.getResponseType()), genericSerializer);
        this.metadata = new GrpcMetadata(query.getMetaDataMap(), messageSerializer);
    }

    public GrpcBackedQueryMessage(QueryRequest query, Serializer messageSerializer, LazyDeserializingObject<Q> serializedPayload, LazyDeserializingObject<ResponseType<R>> serializedResponseType, Supplier<MetaData> metadata) {
        this.query = query;
        this.messageSerializer = messageSerializer;
        this.serializedPayload = serializedPayload;
        this.serializedResponseType = serializedResponseType;
        this.metadata = metadata;
    }

    public String getQueryName() {
        return this.query.getQuery();
    }

    public ResponseType<R> getResponseType() {
        return (ResponseType)this.serializedResponseType.getObject();
    }

    public String getIdentifier() {
        return this.query.getMessageIdentifier();
    }

    public MetaData getMetaData() {
        return this.metadata.get();
    }

    public Q getPayload() {
        return (Q)this.serializedPayload.getObject();
    }

    public Class<Q> getPayloadType() {
        return this.serializedPayload.getType();
    }

    public QueryMessage<Q, R> withMetaData(Map<String, ?> metaData) {
        return new GrpcBackedQueryMessage<Q, R>(this.query, this.messageSerializer, this.serializedPayload, this.serializedResponseType, () -> MetaData.from((Map)metaData));
    }

    public QueryMessage<Q, R> andMetaData(Map<String, ?> metaData) {
        return this.withMetaData((Map<String, ?>)this.getMetaData().mergedWith(metaData));
    }
}

