/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.ProcessingInstruction;
import io.axoniq.axonserver.grpc.ProcessingKey;
import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.query.GrpcBackedQueryMessage;
import org.axonframework.axonserver.connector.query.GrpcBackedResponseMessage;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.axonserver.connector.util.GrpcMetaDataConverter;
import org.axonframework.axonserver.connector.util.GrpcMetadataSerializer;
import org.axonframework.axonserver.connector.util.GrpcObjectSerializer;
import org.axonframework.axonserver.connector.util.GrpcPayloadSerializer;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.serialization.Serializer;

public class QuerySerializer {
    private final Serializer genericSerializer;
    private final Serializer messageSerializer;
    private final AxonServerConfiguration configuration;
    private final GrpcPayloadSerializer payloadSerializer;
    private final GrpcObjectSerializer<Object> responseTypeSerializer;
    private final GrpcMetadataSerializer metadataSerializer;

    public QuerySerializer(Serializer messageSerializer, Serializer genericSerializer, AxonServerConfiguration configuration) {
        this.genericSerializer = genericSerializer;
        this.messageSerializer = messageSerializer;
        this.configuration = configuration;
        this.payloadSerializer = new GrpcPayloadSerializer(messageSerializer);
        this.responseTypeSerializer = new GrpcObjectSerializer(genericSerializer);
        this.metadataSerializer = new GrpcMetadataSerializer(new GrpcMetaDataConverter(this.messageSerializer));
    }

    public <Q, R> QueryMessage<Q, R> deserializeRequest(QueryRequest query) {
        return new GrpcBackedQueryMessage(query, this.messageSerializer, this.genericSerializer);
    }

    public QueryResponse serializeResponse(QueryResponseMessage<?> response, String requestMessageId) {
        QueryResponse.Builder builder = QueryResponse.newBuilder();
        if (response.isExceptional()) {
            Throwable exceptionResult = response.exceptionResult();
            builder.setErrorCode(ErrorCode.QUERY_EXECUTION_ERROR.errorCode());
            builder.setMessage(ExceptionSerializer.serialize(this.configuration.getClientName(), exceptionResult));
        } else {
            builder.setPayload(this.payloadSerializer.apply((Message)response));
        }
        return builder.putAllMetaData(this.metadataSerializer.apply(response.getMetaData())).setMessageIdentifier(response.getIdentifier()).setRequestIdentifier(requestMessageId).build();
    }

    public <Q, R> QueryRequest serializeRequest(QueryMessage<Q, R> queryMessage, int nrResults, long timeout, int priority) {
        return QueryRequest.newBuilder().setTimestamp(System.currentTimeMillis()).setMessageIdentifier(queryMessage.getIdentifier()).setQuery(queryMessage.getQueryName()).setClientId(this.configuration.getClientName()).setComponentName(this.configuration.getComponentName()).setResponseType((SerializedObject)this.responseTypeSerializer.apply((Object)queryMessage.getResponseType())).setPayload(this.payloadSerializer.apply((Message)queryMessage)).addProcessingInstructions(ProcessingInstruction.newBuilder().setKey(ProcessingKey.NR_OF_RESULTS).setValue(MetaDataValue.newBuilder().setNumberValue(nrResults))).addProcessingInstructions(ProcessingInstruction.newBuilder().setKey(ProcessingKey.TIMEOUT).setValue(MetaDataValue.newBuilder().setNumberValue(timeout))).addProcessingInstructions(ProcessingInstruction.newBuilder().setKey(ProcessingKey.PRIORITY).setValue(MetaDataValue.newBuilder().setNumberValue(priority))).putAllMetaData(this.metadataSerializer.apply(queryMessage.getMetaData())).build();
    }

    public <R> QueryResponseMessage<R> deserializeResponse(QueryResponse commandResponse) {
        return new GrpcBackedResponseMessage(commandResponse, this.messageSerializer);
    }
}

