/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.processor.grpc;

import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.processor.EventProcessorInfoSource;
import org.axonframework.axonserver.connector.processor.grpc.EventProcessors;
import org.axonframework.axonserver.connector.processor.grpc.GrpcEventProcessorMapping;
import org.axonframework.axonserver.connector.processor.grpc.PlatformInboundMessage;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.eventhandling.EventProcessor;

public class GrpcEventProcessorInfoSource
implements EventProcessorInfoSource {
    private final Map<String, PlatformInboundInstruction> lastProcessorsInfo = new HashMap<String, PlatformInboundInstruction>();
    private final EventProcessors eventProcessors;
    private final Consumer<PlatformInboundInstruction> send;
    private final Function<EventProcessor, PlatformInboundMessage> mapping;

    public GrpcEventProcessorInfoSource(EventProcessingConfiguration eventProcessingConfiguration, AxonServerConnectionManager axonServerConnectionManager) {
        this(new EventProcessors(eventProcessingConfiguration), axonServerConnectionManager::send, new GrpcEventProcessorMapping());
        axonServerConnectionManager.addReconnectListener(this.lastProcessorsInfo::clear);
    }

    GrpcEventProcessorInfoSource(EventProcessors eventProcessors, Consumer<PlatformInboundInstruction> send, Function<EventProcessor, PlatformInboundMessage> mapping) {
        this.eventProcessors = eventProcessors;
        this.send = send;
        this.mapping = mapping;
    }

    @Override
    public void notifyInformation() {
        this.eventProcessors.forEach(processor -> {
            PlatformInboundInstruction instruction = this.mapping.apply((EventProcessor)processor).instruction();
            if (!instruction.equals(this.lastProcessorsInfo.get(processor.getName()))) {
                this.send.accept(instruction);
            }
            this.lastProcessorsInfo.put(processor.getName(), instruction);
        });
    }
}

