/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.processor;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.eventhandling.TrackingEventProcessor;

public class EventProcessorController {
    private final EventProcessingConfiguration eventProcessingConfiguration;
    private final Deque<Consumer<String>> pauseHandlers = new ArrayDeque<Consumer<String>>();
    private final Deque<Consumer<String>> startHandlers = new ArrayDeque<Consumer<String>>();

    public EventProcessorController(EventProcessingConfiguration eventProcessingConfiguration) {
        this.eventProcessingConfiguration = eventProcessingConfiguration;
    }

    public EventProcessor getEventProcessor(String processorName) {
        return (EventProcessor)this.eventProcessingConfiguration.eventProcessor(processorName).orElseThrow(() -> new RuntimeException("Processor not found"));
    }

    public void pauseProcessor(String processor) {
        this.getEventProcessor(processor).shutDown();
        this.pauseHandlers.forEach(consumer -> consumer.accept(processor));
    }

    public void startProcessor(String processor) {
        this.getEventProcessor(processor).start();
        this.startHandlers.forEach(consumer -> consumer.accept(processor));
    }

    public void releaseSegment(String processor, int segmentId) {
        EventProcessor eventProcessor = this.getEventProcessor(processor);
        if (eventProcessor instanceof TrackingEventProcessor) {
            ((TrackingEventProcessor)eventProcessor).releaseSegment(segmentId);
        }
    }

    public void onPause(Consumer<String> consumer) {
        this.pauseHandlers.add(consumer);
    }

    public void onStart(Consumer<String> consumer) {
        this.startHandlers.add(consumer);
    }
}

