/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event.util;

import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import org.axonframework.axonserver.connector.event.util.EventStoreClientException;

public class GrpcExceptionParser {
    private static Metadata.Key<String> ERROR_CODE_KEY = Metadata.Key.of((String)"AxonIQ-ErrorCode", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public static RuntimeException parse(Throwable ex) {
        String code = "AXONIQ-0001";
        if (ex instanceof StatusRuntimeException) {
            if (ex.getCause() instanceof EventStoreClientException) {
                return (EventStoreClientException)ex.getCause();
            }
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)ex;
            if (Status.Code.UNIMPLEMENTED.equals((Object)statusRuntimeException.getStatus().getCode())) {
                return new UnsupportedOperationException(ex.getMessage(), ex);
            }
            Metadata trailer = statusRuntimeException.getTrailers();
            String errorCode = (String)trailer.get(ERROR_CODE_KEY);
            if (errorCode != null) {
                code = errorCode;
            }
        }
        return new EventStoreClientException(code, ex.getMessage(), ex);
    }
}

