/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import io.axoniq.axonserver.grpc.MetaDataValue;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.axonserver.connector.util.GrpcSerializedObject;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class GrpcMetadata
implements Supplier<MetaData> {
    private final Map<String, MetaDataValue> map;
    private final Serializer messageSerializer;
    private final List<MetaData> metaData = new LinkedList<MetaData>();

    public GrpcMetadata(Map<String, MetaDataValue> map, Serializer messageSerializer) {
        this.map = map;
        this.messageSerializer = messageSerializer;
    }

    @Override
    public MetaData get() {
        if (this.metaData.isEmpty()) {
            if (this.map.isEmpty()) {
                this.metaData.add(MetaData.emptyInstance());
            } else {
                this.metaData.add(MetaData.from(this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.convert((MetaDataValue)e.getValue())))));
            }
        }
        return this.metaData.get(0);
    }

    private Object convert(MetaDataValue value) {
        switch (value.getDataCase()) {
            case TEXT_VALUE: {
                return value.getTextValue();
            }
            case BYTES_VALUE: {
                return this.messageSerializer.deserialize((SerializedObject)new GrpcSerializedObject(value.getBytesValue()));
            }
            case DOUBLE_VALUE: {
                return value.getDoubleValue();
            }
            case NUMBER_VALUE: {
                return value.getNumberValue();
            }
            case BOOLEAN_VALUE: {
                return value.getBooleanValue();
            }
            case DATA_NOT_SET: {
                return null;
            }
        }
        return null;
    }
}

