/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.repository;

import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.core.Context;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.modelling.repository.ManagedEntity;
import org.axonframework.modelling.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessSerializingRepository<ID, E>
implements Repository.LifecycleManagement<ID, E>,
DescribableComponent {
    private static final Logger logger = LoggerFactory.getLogger(AccessSerializingRepository.class);
    private final Context.ResourceKey<ConcurrentMap<ID, CompletableFuture<ManagedEntity<ID, E>>>> workingEntitiesKey = Context.ResourceKey.withLabel((String)"workingEntities");
    private final Repository.LifecycleManagement<ID, E> delegate;
    private final ConcurrentMap<ID, CompletableFuture<ManagedEntity<ID, E>>> inProgress;

    public AccessSerializingRepository(Repository.LifecycleManagement<ID, E> delegate) {
        this.delegate = delegate;
        this.inProgress = new ConcurrentHashMap<ID, CompletableFuture<ManagedEntity<ID, E>>>();
    }

    @Override
    public ManagedEntity<ID, E> attach(@Nonnull ManagedEntity<ID, E> entity, @Nonnull ProcessingContext processingContext) {
        return this.delegate.attach(entity, processingContext);
    }

    @Override
    @Nonnull
    public Class<E> entityType() {
        return this.delegate.entityType();
    }

    @Override
    @Nonnull
    public Class<ID> idType() {
        return this.delegate.idType();
    }

    @Override
    public CompletableFuture<ManagedEntity<ID, E>> load(@Nonnull ID identifier, @Nonnull ProcessingContext processingContext) {
        return this.awaitTurn(identifier, processingContext, () -> this.delegate.load(identifier, processingContext));
    }

    @Override
    public CompletableFuture<ManagedEntity<ID, E>> loadOrCreate(@Nonnull ID identifier, @Nonnull ProcessingContext processingContext) {
        return this.awaitTurn(identifier, processingContext, () -> this.delegate.loadOrCreate(identifier, processingContext));
    }

    private CompletableFuture<ManagedEntity<ID, E>> awaitTurn(ID identifier, ProcessingContext processingContext, Supplier<CompletableFuture<ManagedEntity<ID, E>>> entitySupplier) {
        CompletionStage previousTask;
        logger.debug("Attempting to load [{}] in {}", identifier, (Object)processingContext);
        ConcurrentMap workingEntities = (ConcurrentMap)processingContext.computeResourceIfAbsent(this.workingEntitiesKey, ConcurrentHashMap::new);
        if (workingEntities.containsKey(identifier)) {
            logger.debug("Found a working entity for [{}] in {}. Returning it.", identifier, (Object)processingContext);
            return (CompletableFuture)workingEntities.get(identifier);
        }
        CompletableFuture doneMarker = new CompletableFuture();
        CompletableFuture previousMarker = this.inProgress.put(identifier, doneMarker);
        doneMarker.whenComplete((r, e) -> this.inProgress.remove(identifier, doneMarker));
        if (previousMarker == null) {
            logger.debug("No previous task found for loading [{}]. Performing actual load.", identifier);
            previousTask = FutureUtils.emptyCompletedFuture();
        } else {
            logger.debug("Previous task detected. Will wait for it to complete before loading [{}] in {}.", identifier, (Object)processingContext);
            previousTask = previousMarker.whenComplete((r, e) -> logger.debug("Previous task completed. Processing {} in {}.", new Object[]{r, processingContext, e}));
        }
        return ((CompletableFuture)((CompletableFuture)previousTask.exceptionally(e -> {
            logger.warn("Previous task finished with exception.", e);
            return null;
        })).thenCompose(previousEntity -> {
            CompletableFuture<ManagedEntity<ID, E>> workingEntity;
            if (previousEntity == null) {
                logger.debug("Previous task for [{}] did not exist or completed with a failure. Loading from delegate in {}.", identifier, (Object)processingContext);
            } else {
                logger.debug("Previous task finished successfully and transferred entity [{}] to {}.", identifier, (Object)processingContext);
            }
            if (previousEntity == null) {
                logger.debug("Calling entity supplier in {} to load or create [{}].", (Object)processingContext, identifier);
                workingEntity = (CompletableFuture<ManagedEntity<ID, E>>)entitySupplier.get();
            } else {
                logger.debug("Received [{}] in {}. Registering as managed instance.", identifier, (Object)processingContext);
                workingEntity = CompletableFuture.completedFuture(this.delegate.attach((ManagedEntity<ID, E>)previousEntity, processingContext));
            }
            workingEntities.put(identifier, workingEntity);
            return workingEntity.whenComplete((r, e) -> {
                logger.debug("Entity [{}] released in {}.", identifier, (Object)processingContext);
                processingContext.whenComplete(pc -> {
                    logger.debug("Processing in {} completed successfully. Passing [{}] to next task.", (Object)processingContext, identifier);
                    doneMarker.complete(((CompletableFuture)workingEntities.get(identifier)).getNow(null));
                });
                processingContext.onError((pc, phase, error) -> {
                    logger.warn("Processing in {} completed with error. Triggering next task to continue without [{}].", (Object)processingContext, identifier);
                    doneMarker.complete(null);
                });
            });
        })).thenApply(Function.identity());
    }

    @Override
    public ManagedEntity<ID, E> persist(@Nonnull ID identifier, @Nonnull E entity, @Nonnull ProcessingContext processingContext) {
        ManagedEntity<ID, E> persisted;
        ConcurrentMap workingEntities = (ConcurrentMap)processingContext.computeResourceIfAbsent(this.workingEntitiesKey, ConcurrentHashMap::new);
        if (workingEntities.put(identifier, CompletableFuture.completedFuture(persisted = this.delegate.persist(identifier, entity, processingContext))) == null) {
            CompletableFuture doneMarker = new CompletableFuture();
            this.inProgress.put(identifier, doneMarker);
            processingContext.whenComplete(pc -> ((CompletableFuture)workingEntities.get(identifier)).getNow(null));
            processingContext.onError((pc, phase, error) -> doneMarker.complete(null));
        }
        return persisted;
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
    }
}

