/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling;

import jakarta.annotation.Nonnull;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.modelling.repository.ManagedEntity;
import org.axonframework.modelling.repository.Repository;
import org.axonframework.modelling.repository.SimpleRepository;
import org.axonframework.modelling.repository.SimpleRepositoryEntityLoader;
import org.axonframework.modelling.repository.SimpleRepositoryEntityPersister;

public interface StateManager {
    public <ID, T> StateManager register(@Nonnull Repository<ID, T> var1);

    default public <ID, T> StateManager register(@Nonnull Class<ID> idType, @Nonnull Class<T> entityType, @Nonnull SimpleRepositoryEntityLoader<ID, T> loader, @Nonnull SimpleRepositoryEntityPersister<ID, T> persister) {
        return this.register(new SimpleRepository<ID, T>(idType, entityType, loader, persister));
    }

    @Nonnull
    default public <I, T> CompletableFuture<T> loadEntity(@Nonnull Class<T> type, @Nonnull I id, @Nonnull ProcessingContext context) {
        return this.loadManagedEntity(type, id, context).thenApply(ManagedEntity::entity);
    }

    public <ID, T> CompletableFuture<ManagedEntity<ID, T>> loadManagedEntity(@Nonnull Class<T> var1, @Nonnull ID var2, @Nonnull ProcessingContext var3);

    public Set<Class<?>> registeredEntities();

    public Set<Class<?>> registeredIdsFor(@Nonnull Class<?> var1);

    public <ID, T> Repository<ID, T> repository(@Nonnull Class<T> var1, @Nonnull Class<ID> var2);
}

