/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.repository;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.repository.ManagedEntity;
import org.axonframework.modelling.repository.Repository;
import org.axonframework.modelling.repository.SimpleRepository;

public class InMemoryRepository<ID, E>
implements Repository.LifecycleManagement<ID, E> {
    private final SimpleRepository<ID, E> delegate;
    private final ConcurrentMap<ID, E> storage;

    public InMemoryRepository(@Nonnull Class<ID> idType, @Nonnull Class<E> entityType) {
        Objects.requireNonNull(idType, "The idType may not be null");
        Objects.requireNonNull(entityType, "The entityType may not be null");
        this.storage = new ConcurrentHashMap<ID, E>();
        this.delegate = new SimpleRepository<Object, Object>(idType, entityType, (identifier, processingContext) -> CompletableFuture.completedFuture(this.storage.get(identifier)), (identifier, entity, processingContext) -> {
            if (entity != null) {
                this.storage.put(identifier, entity);
            }
            return FutureUtils.emptyCompletedFuture();
        });
    }

    @Override
    public ManagedEntity<ID, E> attach(@Nonnull ManagedEntity<ID, E> entity, @Nonnull ProcessingContext processingContext) {
        return this.delegate.attach(entity, processingContext);
    }

    @Override
    @Nonnull
    public Class<E> entityType() {
        return this.delegate.entityType();
    }

    @Override
    @Nonnull
    public Class<ID> idType() {
        return this.delegate.idType();
    }

    @Override
    public CompletableFuture<ManagedEntity<ID, E>> load(@Nonnull ID identifier, @Nonnull ProcessingContext processingContext) {
        return this.delegate.load(identifier, processingContext);
    }

    @Override
    public CompletableFuture<ManagedEntity<ID, E>> loadOrCreate(@Nonnull ID identifier, @Nonnull ProcessingContext processingContext) {
        return this.delegate.loadOrCreate(identifier, processingContext);
    }

    @Override
    public ManagedEntity<ID, E> persist(@Nonnull ID identifier, @Nonnull E entity, @Nonnull ProcessingContext processingContext) {
        return this.delegate.persist(identifier, entity, processingContext);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("storageType", "ConcurrentHashMap");
        descriptor.describeProperty("storageSize", (Object)this.storage.size());
        descriptor.describeWrapperOf(this.delegate);
    }
}

