/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.annotations;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.axonframework.configuration.Configuration;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotations.ParameterResolver;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.EntityIdResolver;
import org.axonframework.modelling.StateManager;
import org.axonframework.modelling.annotations.NullEntityIdInPayloadException;

class InjectEntityParameterResolver
implements ParameterResolver<Object> {
    private final Configuration configuration;
    private final Class<?> type;
    private final EntityIdResolver<?> identifierResolver;
    private final boolean managedEntity;

    public InjectEntityParameterResolver(@Nonnull Configuration configuration, @Nonnull Class<?> type, @Nonnull EntityIdResolver<?> identifierResolver, boolean managedEntity) {
        this.configuration = Objects.requireNonNull(configuration, "The Configuration is required");
        this.type = Objects.requireNonNull(type, "The type is required");
        this.identifierResolver = Objects.requireNonNull(identifierResolver, "The ModelIdentifierResolver is required");
        this.managedEntity = managedEntity;
    }

    @Nullable
    public Object resolveParameterValue(@Nonnull ProcessingContext context) {
        Message message = Message.fromContext((ProcessingContext)context);
        Object resolvedId = this.identifierResolver.resolve(message, context);
        if (resolvedId == null) {
            throw new NullEntityIdInPayloadException(message.payload().getClass());
        }
        StateManager stateManager = (StateManager)this.configuration.getComponent(StateManager.class);
        if (this.managedEntity) {
            return stateManager.loadManagedEntity(this.type, resolvedId, context).join();
        }
        return stateManager.loadEntity(this.type, resolvedId, context).join();
    }

    public boolean matches(@Nonnull ProcessingContext context) {
        return Message.fromContext((ProcessingContext)context) != null;
    }
}

