/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.annotation;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.modelling.EntityIdResolutionException;
import org.axonframework.modelling.EntityIdResolver;
import org.axonframework.modelling.StateManager;

class InjectEntityParameterResolver
implements ParameterResolver<Object> {
    private final Configuration configuration;
    private final Class<?> type;
    private final EntityIdResolver<?> identifierResolver;
    private final boolean managedEntity;

    public InjectEntityParameterResolver(@Nonnull Configuration configuration, @Nonnull Class<?> type, @Nonnull EntityIdResolver<?> identifierResolver, boolean managedEntity) {
        this.configuration = Objects.requireNonNull(configuration, "The Configuration is required");
        this.type = Objects.requireNonNull(type, "The type is required");
        this.identifierResolver = Objects.requireNonNull(identifierResolver, "The ModelIdentifierResolver is required");
        this.managedEntity = managedEntity;
    }

    @Nonnull
    public CompletableFuture<Object> resolveParameterValue(@Nonnull ProcessingContext context) {
        Message message = Message.fromContext((ProcessingContext)context);
        try {
            Object resolvedId = this.identifierResolver.resolve(message, context);
            StateManager stateManager = (StateManager)this.configuration.getComponent(StateManager.class);
            if (this.managedEntity) {
                CompletableFuture<Object> castCompletableFuture = stateManager.loadManagedEntity(this.type, resolvedId, context);
                return castCompletableFuture;
            }
            CompletableFuture<Object> castCompletableFuture = stateManager.loadEntity(this.type, resolvedId, context);
            return castCompletableFuture;
        }
        catch (EntityIdResolutionException e) {
            return CompletableFuture.failedFuture(new IllegalStateException("Unable to inject entity parameter of type [%s] because [%s] was unable to resolve an entity id from [%s]".formatted(this.type, this.identifierResolver, message), e));
        }
    }

    public boolean matches(@Nonnull ProcessingContext context) {
        return Message.fromContext((ProcessingContext)context) != null;
    }
}

