/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.annotation;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.MessageTypeResolver;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.core.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.core.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.core.annotation.HandlerDefinition;
import org.axonframework.messaging.core.annotation.MessageHandlingMember;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.interception.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.conversion.EventConverter;
import org.axonframework.modelling.EntityEvolvingComponent;
import org.axonframework.modelling.StateEvolvingException;

public class AnnotationBasedEntityEvolvingComponent<E>
implements EntityEvolvingComponent<E> {
    private final Class<E> entityType;
    private final AnnotatedHandlerInspector<E> inspector;
    private final EventConverter converter;
    private final MessageTypeResolver messageTypeResolver;

    public AnnotationBasedEntityEvolvingComponent(@Nonnull Class<E> entityType, @Nonnull EventConverter converter, @Nonnull MessageTypeResolver messageTypeResolver) {
        this(entityType, AnnotatedHandlerInspector.inspectType(entityType, (ParameterResolverFactory)ClasspathParameterResolverFactory.forClass(entityType), (HandlerDefinition)ClasspathHandlerDefinition.forClass(entityType)), converter, messageTypeResolver);
    }

    public AnnotationBasedEntityEvolvingComponent(@Nonnull Class<E> entityType, @Nonnull AnnotatedHandlerInspector<E> inspector, @Nonnull EventConverter converter, @Nonnull MessageTypeResolver messageTypeResolver) {
        this.entityType = Objects.requireNonNull(entityType, "The entity type must not be null.");
        this.inspector = Objects.requireNonNull(inspector, "The Annotated Handler Inspector must not be null.");
        this.converter = Objects.requireNonNull(converter, "The Converter must not be null.");
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "The Message Type Resolver must not be null.");
    }

    @Override
    public E evolve(@Nonnull E entity, @Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        try {
            Class<?> listenerType = entity.getClass();
            String eventTypeName = event.type().name();
            List<MessageHandlingMember> handlers = this.inspector.getHandlers(listenerType).filter(h -> this.messageTypeResolver.resolveOrThrow(h.payloadType()).name().equals(eventTypeName)).toList();
            E evolvedEntity = entity;
            for (MessageHandlingMember handler : handlers) {
                EventMessage convertedEvent;
                if (!handler.canHandle((Message)(convertedEvent = event.withConvertedPayload(handler.payloadType(), (Converter)this.converter)), context)) continue;
                MessageHandlerInterceptorMemberChain interceptor = this.inspector.chainedInterceptor(listenerType);
                MessageStream.Entry result = (MessageStream.Entry)interceptor.handle((Message)convertedEvent, context, entity, handler).first().asCompletableFuture().join();
                evolvedEntity = this.entityFromStreamResultOrUpdatedExisting(result, entity);
            }
            return evolvedEntity;
        }
        catch (Exception e) {
            throw new StateEvolvingException("Failed to apply event [" + String.valueOf(event.type()) + "] in order to evolve [" + String.valueOf(entity.getClass()) + "] state", e);
        }
    }

    private E entityFromStreamResultOrUpdatedExisting(MessageStream.Entry<?> potentialEntityFromStream, E existing) {
        Object resultPayload;
        if (potentialEntityFromStream != null && (resultPayload = potentialEntityFromStream.message().payload()) != null && existing.getClass().isAssignableFrom(resultPayload.getClass())) {
            return (E)existing.getClass().cast(resultPayload);
        }
        return existing;
    }

    @Override
    @Nonnull
    public Set<QualifiedName> supportedEvents() {
        return this.inspector.getHandlers(this.entityType).filter(Objects::nonNull).map(MessageHandlingMember::payloadType).map(QualifiedName::new).collect(Collectors.toSet());
    }
}

