/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.child;

import jakarta.annotation.Nonnull;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.StringUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.modelling.entity.child.ChildEntityFieldDefinition;

public class FieldChildEntityFieldDefinition<P, F>
implements ChildEntityFieldDefinition<P, F>,
DescribableComponent {
    private final Field field;
    private final Class<P> parentClass;
    private final String fieldName;
    private Method optionalGetter;
    private Method optionalSetter;

    public FieldChildEntityFieldDefinition(@Nonnull Class<P> parentClass, @Nonnull String fieldName) {
        this.parentClass = Objects.requireNonNull(parentClass, "The parentClass may not be null.");
        this.fieldName = Objects.requireNonNull(fieldName, "The fieldName may not be null.");
        this.field = StreamSupport.stream(ReflectionUtils.fieldsOf(parentClass).spliterator(), false).filter(f -> f.getName().equals(fieldName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Field [%s] not found in class [%s]", fieldName, parentClass.getName())));
        ReflectionUtils.ensureAccessible((AccessibleObject)this.field);
        this.detectOptionalGetter(parentClass, this.field);
        this.detectOptionalSetter(parentClass, this.field);
    }

    private void detectOptionalGetter(Class<P> parentClass, Field field) {
        this.optionalGetter = StreamSupport.stream(ReflectionUtils.methodsOf(parentClass).spliterator(), false).filter(m -> m.getParameterCount() == 0).filter(m -> m.getName().equals(field.getName()) || m.getName().equals("get" + StringUtils.capitalize((String)field.getName()))).findFirst().orElse(null);
        if (this.optionalGetter != null) {
            ReflectionUtils.ensureAccessible((AccessibleObject)this.optionalGetter);
        }
    }

    private void detectOptionalSetter(Class<P> parentClass, Field field) {
        this.optionalSetter = StreamSupport.stream(ReflectionUtils.methodsOf(parentClass).spliterator(), false).filter(m -> m.getParameterCount() == 1).filter(m -> m.getName().equals(field.getName()) || m.getName().equals("set" + StringUtils.capitalize((String)field.getName())) || m.getName().equals("evolve" + StringUtils.capitalize((String)field.getName()))).findFirst().orElse(null);
        if (this.optionalSetter != null) {
            ReflectionUtils.ensureAccessible((AccessibleObject)this.optionalSetter);
        }
    }

    @Override
    @Nonnull
    public P evolveParentBasedOnChildInput(@Nonnull P parentEntity, @Nonnull F childInput) {
        try {
            Object invokeResult;
            if (this.optionalSetter != null && (invokeResult = this.optionalSetter.invoke(parentEntity, childInput)) != null) {
                if (!this.parentClass.isAssignableFrom(invokeResult.getClass())) {
                    throw new IllegalArgumentException(String.format("Evolve method [%s] must return a type compatible with entity type [%s]", this.optionalSetter.getName(), this.parentClass.getName()));
                }
                return (P)invokeResult;
            }
            this.field.set(parentEntity, childInput);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return parentEntity;
    }

    @Override
    public F getChildValue(@Nonnull P parentEntity) {
        try {
            if (this.optionalGetter != null) {
                return (F)this.optionalGetter.invoke(parentEntity, new Object[0]);
            }
            return (F)this.field.get(parentEntity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("parentClass", this.parentClass);
        descriptor.describeProperty("fieldName", this.fieldName);
        descriptor.describeProperty("field", (Object)this.field);
        descriptor.describeProperty("optionalGetter", (Object)this.optionalGetter);
        descriptor.describeProperty("optionalSetter", (Object)this.optionalSetter);
    }
}

