/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.annotations;

import jakarta.annotation.Nonnull;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.EntityIdResolutionException;
import org.axonframework.modelling.EntityIdResolver;
import org.axonframework.modelling.annotations.TargetEntityId;

public class AnnotationBasedEntityIdResolver<T>
implements EntityIdResolver<T> {
    private static final Class<TargetEntityId> IDENTIFIER_ANNOTATION = TargetEntityId.class;
    private final Map<Class<?>, List<Member>> cache = new ConcurrentHashMap();

    @Override
    @Nonnull
    public T resolve(@Nonnull Message message, @Nonnull ProcessingContext context) throws EntityIdResolutionException {
        Object payload = message.payload();
        List<Object> identifiers = this.getIdentifiers(payload).stream().filter(Objects::nonNull).toList();
        if (identifiers.size() == 1) {
            Object first = identifiers.getFirst();
            return (T)first;
        }
        throw new EntityIdResolutionException(payload.getClass(), identifiers);
    }

    private List<Object> getIdentifiers(Object payload) {
        List<Member> members = this.getMembers(payload.getClass());
        return members.stream().map(field -> ReflectionUtils.getMemberValue((Member)field, (Object)payload)).filter(Objects::nonNull).distinct().toList();
    }

    private List<Member> getMembers(Class<?> type) {
        return this.cache.computeIfAbsent(type, this::findMembers);
    }

    private List<Member> findMembers(Class<?> type) {
        Stream<Field> fields = StreamSupport.stream(ReflectionUtils.fieldsOf(type).spliterator(), false).filter(this::hasIdentifierAnnotation);
        Stream<Method> methods = StreamSupport.stream(ReflectionUtils.methodsOf(type).spliterator(), false).filter(this::hasIdentifierAnnotation);
        return Stream.concat(fields, methods).map(arg_0 -> AnnotationBasedEntityIdResolver.lambda$findMembers$1(Member.class, arg_0)).toList();
    }

    private boolean hasIdentifierAnnotation(AnnotatedElement member) {
        return member.isAnnotationPresent(IDENTIFIER_ANNOTATION);
    }

    private static /* synthetic */ Member lambda$findMembers$1(Class rec$, Object x$0) {
        return (Member)rec$.cast(x$0);
    }
}

