/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.LoadedEntityNotOfExpectedTypeException;
import org.axonframework.modelling.MissingRepositoryException;
import org.axonframework.modelling.RepositoryAlreadyRegisteredException;
import org.axonframework.modelling.StateManager;
import org.axonframework.modelling.repository.ManagedEntity;
import org.axonframework.modelling.repository.Repository;

public class SimpleStateManager
implements StateManager,
DescribableComponent {
    private final String name;
    private final List<Repository<?, ?>> repositories = new CopyOnWriteArrayList();

    public static StateManager named(@Nonnull String name) {
        return new SimpleStateManager(name);
    }

    private SimpleStateManager(@Nonnull String name) {
        BuilderUtils.assertNonEmpty((String)name, (String)"The name must be non-empty.");
        this.name = name;
    }

    @Nonnull
    public <I, T> CompletableFuture<ManagedEntity<I, T>> loadManagedEntity(@Nonnull Class<T> entityType, @Nonnull I id, @Nonnull ProcessingContext context) {
        Repository repository = this.repositories.stream().filter(r -> r.entityType().isAssignableFrom(entityType)).filter(r -> r.idType().isAssignableFrom(id.getClass())).map(r -> r).findFirst().orElseThrow(() -> new MissingRepositoryException(id.getClass(), entityType));
        return repository.loadOrCreate(id, context).thenApply(me -> {
            if (me.entity() != null && !entityType.isInstance(me.entity())) {
                throw new LoadedEntityNotOfExpectedTypeException(me.entity().getClass(), entityType);
            }
            return me;
        });
    }

    @Override
    public Set<Class<?>> registeredEntities() {
        return this.repositories.stream().map(Repository::entityType).collect(Collectors.toSet());
    }

    @Override
    public Set<Class<?>> registeredIdsFor(@Nonnull Class<?> entityType) {
        return this.repositories.stream().filter(r -> r.entityType().equals(entityType)).map(Repository::idType).collect(Collectors.toSet());
    }

    public <I, T> Repository<I, T> repository(@Nonnull Class<T> entityType, @Nonnull Class<I> idType) {
        return this.repositories.stream().filter(r -> r.entityType().equals(entityType)).filter(r -> r.idType().equals(idType)).findFirst().orElse(null);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("name", this.name);
        descriptor.describeProperty("repositories", this.repositories);
    }

    public <I, T> StateManager register(@Nonnull Repository<I, T> repository) {
        Objects.requireNonNull(repository, "The repository must not be null.");
        Optional<Repository> registeredRepository = this.repositories.stream().filter(r -> this.match((Repository<?, ?>)r, repository)).findFirst();
        if (registeredRepository.isPresent()) {
            throw new RepositoryAlreadyRegisteredException(repository, registeredRepository.get());
        }
        this.repositories.add(repository);
        return this;
    }

    private boolean match(Repository<?, ?> repositoryOne, Repository<?, ?> repositoryTwo) {
        return SimpleStateManager.matchesBasedOnEntityType(repositoryOne, repositoryTwo) && SimpleStateManager.matchesBasedOnIdType(repositoryOne, repositoryTwo);
    }

    private static boolean matchesBasedOnIdType(Repository<?, ?> repositoryOne, Repository<?, ?> repositoryTwo) {
        return repositoryOne.idType().isAssignableFrom(repositoryTwo.idType()) || repositoryTwo.idType().isAssignableFrom(repositoryOne.idType());
    }

    private static boolean matchesBasedOnEntityType(Repository<?, ?> repositoryOne, Repository<?, ?> repositoryTwo) {
        return repositoryOne.entityType().isAssignableFrom(repositoryTwo.entityType()) || repositoryTwo.entityType().isAssignableFrom(repositoryOne.entityType());
    }
}

