/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.metamodel;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.SagaMethodMessageHandlingMember;
import org.axonframework.modelling.saga.metamodel.SagaMetaModelFactory;
import org.axonframework.modelling.saga.metamodel.SagaModel;

public class AnnotationSagaMetaModelFactory
implements SagaMetaModelFactory {
    private final Map<Class<?>, SagaModel<?>> registry = new ConcurrentHashMap();
    private final Map<Class<?>, MessageHandlerInterceptorMemberChain<?>> interceptorRegistry = new ConcurrentHashMap();
    private final ParameterResolverFactory parameterResolverFactory;
    private final HandlerDefinition handlerDefinition;

    public AnnotationSagaMetaModelFactory() {
        this(ClasspathParameterResolverFactory.forClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader()));
    }

    public AnnotationSagaMetaModelFactory(ParameterResolverFactory parameterResolverFactory) {
        this(parameterResolverFactory, (HandlerDefinition)ClasspathHandlerDefinition.forClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader()));
    }

    public AnnotationSagaMetaModelFactory(ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this.parameterResolverFactory = parameterResolverFactory;
        this.handlerDefinition = handlerDefinition;
    }

    @Override
    public <T> SagaModel<T> modelOf(Class<T> sagaType) {
        return this.registry.computeIfAbsent(sagaType, this::doCreateModel);
    }

    @Override
    public <T> MessageHandlerInterceptorMemberChain<T> chainedInterceptor(Class<T> sagaType) {
        return this.interceptorRegistry.computeIfAbsent(sagaType, this::doCreateChain);
    }

    private <T> SagaModel<T> doCreateModel(Class<T> sagaType) {
        AnnotatedHandlerInspector handlerInspector = AnnotatedHandlerInspector.inspectType(sagaType, (ParameterResolverFactory)this.parameterResolverFactory, (HandlerDefinition)this.handlerDefinition);
        return new InspectedSagaModel(handlerInspector.getHandlers(sagaType).collect(Collectors.toList()));
    }

    private <T> MessageHandlerInterceptorMemberChain<T> doCreateChain(Class<T> sagaType) {
        AnnotatedHandlerInspector handlerInspector = AnnotatedHandlerInspector.inspectType(sagaType, (ParameterResolverFactory)this.parameterResolverFactory, (HandlerDefinition)this.handlerDefinition);
        return handlerInspector.chainedInterceptor(sagaType);
    }

    private class InspectedSagaModel<T>
    implements SagaModel<T> {
        private final List<MessageHandlingMember<? super T>> handlers;

        public InspectedSagaModel(List<MessageHandlingMember<? super T>> handlers) {
            this.handlers = handlers;
        }

        @Override
        public Optional<AssociationValue> resolveAssociation(EventMessage eventMessage, ProcessingContext context) {
            for (MessageHandlingMember<? super T> messageHandlingMember : this.handlers) {
                if (!messageHandlingMember.canHandle((Message)eventMessage, context)) continue;
                return messageHandlingMember.unwrap(SagaMethodMessageHandlingMember.class).map(mh -> mh.getAssociationValue(eventMessage));
            }
            return Optional.empty();
        }

        @Override
        public List<MessageHandlingMember<? super T>> findHandlerMethods(EventMessage eventMessage, ProcessingContext context) {
            return this.handlers.stream().filter(h -> h.canHandle((Message)eventMessage, context)).collect(Collectors.toList());
        }

        @Override
        public boolean hasHandlerMethod(EventMessage eventMessage, ProcessingContext context) {
            for (MessageHandlingMember<? super T> messageHandlingMember : this.handlers) {
                if (!messageHandlingMember.canHandle((Message)eventMessage, context)) continue;
                return true;
            }
            return false;
        }

        @Override
        public SagaMetaModelFactory modelFactory() {
            return AnnotationSagaMetaModelFactory.this;
        }
    }
}

