/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity;

import jakarta.annotation.Nonnull;
import java.util.Set;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.EntityEvolver;
import org.axonframework.modelling.entity.ConcreteEntityMetamodel;
import org.axonframework.modelling.entity.EntityMetamodelBuilder;
import org.axonframework.modelling.entity.PolymorphicEntityMetamodel;
import org.axonframework.modelling.entity.PolymorphicEntityMetamodelBuilder;

public interface EntityMetamodel<E>
extends EntityEvolver<E>,
DescribableComponent {
    @Nonnull
    public static <E> EntityMetamodelBuilder<E> forEntityType(Class<E> entityType) {
        return ConcreteEntityMetamodel.forEntityClass(entityType);
    }

    @Nonnull
    public static <E> PolymorphicEntityMetamodelBuilder<E> forPolymorphicEntityType(@Nonnull Class<E> entityType) {
        return PolymorphicEntityMetamodel.forSuperType(entityType);
    }

    @Nonnull
    public Class<E> entityType();

    @Nonnull
    public MessageStream.Single<CommandResultMessage<?>> handleCreate(@Nonnull CommandMessage var1, @Nonnull ProcessingContext var2);

    @Nonnull
    public MessageStream.Single<CommandResultMessage<?>> handleInstance(@Nonnull CommandMessage var1, @Nonnull E var2, @Nonnull ProcessingContext var3);

    @Nonnull
    public Set<QualifiedName> supportedCreationalCommands();

    @Nonnull
    public Set<QualifiedName> supportedInstanceCommands();

    @Nonnull
    public Set<QualifiedName> supportedCommands();
}

