/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import jakarta.annotation.Nonnull;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.Message;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.TargetAggregateIdentifier;

public class AnnotationCommandTargetResolver
implements CommandTargetResolver {
    private final Class<? extends Annotation> identifierAnnotation;

    public static Builder builder() {
        return new Builder();
    }

    protected AnnotationCommandTargetResolver(Builder builder) {
        this.identifierAnnotation = builder.identifierAnnotation;
    }

    @Override
    public String resolveTarget(@Nonnull CommandMessage command) {
        Object aggregateIdentifier;
        try {
            aggregateIdentifier = this.findIdentifier((Message)command);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("An exception occurred while extracting aggregate information form a command", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("The current security context does not allow extraction of aggregate information from the given command.", e);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The value provided for the version is not a number.", e);
        }
        if (aggregateIdentifier == null) {
            throw new IllegalArgumentException(String.format("Invalid command. It does not identify the target aggregate. Make sure at least one of the fields or methods in the command of type [%s] contains the @TargetAggregateIdentifier annotation and that it returns a non-null value.", command.type()));
        }
        return aggregateIdentifier.toString();
    }

    private Object findIdentifier(Message command) throws InvocationTargetException, IllegalAccessException {
        return AnnotationCommandTargetResolver.invokeAnnotated(command, this.identifierAnnotation);
    }

    private static Object invokeAnnotated(Message command, Class<? extends Annotation> annotation) throws InvocationTargetException, IllegalAccessException {
        for (Method m : ReflectionUtils.methodsOf((Class)command.payloadType())) {
            if (!AnnotationUtils.isAnnotationPresent((AnnotatedElement)m, annotation)) continue;
            ReflectionUtils.ensureAccessible((AccessibleObject)m);
            return m.invoke(command.payload(), new Object[0]);
        }
        for (Field f : ReflectionUtils.fieldsOf((Class)command.payloadType())) {
            if (!AnnotationUtils.isAnnotationPresent((AnnotatedElement)f, annotation)) continue;
            return ReflectionUtils.getFieldValue((Field)f, (Object)command.payload());
        }
        return null;
    }

    public String toString() {
        return "AnnotationCommandTargetResolver [identifierAnnotation=" + String.valueOf(this.identifierAnnotation) + "]";
    }

    public static final class Builder {
        private Class<? extends Annotation> identifierAnnotation = TargetAggregateIdentifier.class;

        public Builder targetAggregateIdentifierAnnotation(Class<? extends Annotation> annotation) {
            BuilderUtils.assertNonNull(annotation, (String)"TargetAggregateIdentifierAnnotation may not be null");
            this.identifierAnnotation = annotation;
            return this;
        }

        public AnnotationCommandTargetResolver build() {
            return new AnnotationCommandTargetResolver(this);
        }
    }
}

