/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository.jdbc;

public class SagaSchema {
    private final String sagaEntryTable;
    private final String revisionColumn;
    private final String serializedSagaColumn;
    private final String associationValueEntryTable;
    private final String associationKeyColumn;
    private final String associationValueColumn;
    private final String sagaIdColumn;
    private final String sagaTypeColumn;

    public SagaSchema() {
        this(SagaSchema.builder());
    }

    protected SagaSchema(Builder builder) {
        this.sagaEntryTable = builder.sagaEntryTable;
        this.revisionColumn = builder.revisionColumn;
        this.serializedSagaColumn = builder.serializedSagaColumn;
        this.associationValueEntryTable = builder.associationValueEntryTable;
        this.associationKeyColumn = builder.associationKeyColumn;
        this.associationValueColumn = builder.associationValueColumn;
        this.sagaIdColumn = builder.sagaIdColumn;
        this.sagaTypeColumn = builder.sagaTypeColumn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String sagaEntryTable() {
        return this.sagaEntryTable;
    }

    public String revisionColumn() {
        return this.revisionColumn;
    }

    public String serializedSagaColumn() {
        return this.serializedSagaColumn;
    }

    public String associationValueEntryTable() {
        return this.associationValueEntryTable;
    }

    public String associationKeyColumn() {
        return this.associationKeyColumn;
    }

    public String associationValueColumn() {
        return this.associationValueColumn;
    }

    public String sagaIdColumn() {
        return this.sagaIdColumn;
    }

    public String sagaTypeColumn() {
        return this.sagaTypeColumn;
    }

    public static class Builder {
        private String sagaEntryTable = "SagaEntry";
        private String revisionColumn = "revision";
        private String serializedSagaColumn = "serializedSaga";
        private String associationValueEntryTable = "AssociationValueEntry";
        private String associationKeyColumn = "associationKey";
        private String associationValueColumn = "associationValue";
        private String sagaIdColumn = "sagaId";
        private String sagaTypeColumn = "sagaType";

        public Builder sagaEntryTable(String sagaEntryTable) {
            this.sagaEntryTable = sagaEntryTable;
            return this;
        }

        public Builder revisionColumn(String columnName) {
            this.revisionColumn = columnName;
            return this;
        }

        public Builder serializedSagaColumn(String columnName) {
            this.serializedSagaColumn = columnName;
            return this;
        }

        public Builder associationValueEntryTable(String associationValueEntryTable) {
            this.associationValueEntryTable = associationValueEntryTable;
            return this;
        }

        public Builder associationKeyColumn(String columnName) {
            this.associationKeyColumn = columnName;
            return this;
        }

        public Builder associationValueColumn(String columnName) {
            this.associationValueColumn = columnName;
            return this;
        }

        public Builder sagaIdColumn(String columnName) {
            this.sagaIdColumn = columnName;
            return this;
        }

        public Builder sagaTypeColumn(String columnName) {
            this.sagaTypeColumn = columnName;
            return this;
        }

        public SagaSchema build() {
            return new SagaSchema(this);
        }
    }
}

