/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.annotation;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.modelling.entity.annotation.AnnotatedEntityMetamodel;
import org.axonframework.modelling.entity.annotation.UnknownRoutingKeyException;

@Internal
public class AnnotatedEntityModelRoutingKeyMatcher<E> {
    private final Map<MessageType, Property<Object>> messageRoutingPropertyCache;
    private final Map<Class<?>, Property<Object>> entityRoutingPropertyCache;
    private final String entityRoutingProperty;
    private final String messageRoutingProperty;
    private final AnnotatedEntityMetamodel<E> metamodel;

    public AnnotatedEntityModelRoutingKeyMatcher(@Nonnull AnnotatedEntityMetamodel<E> metamodel, @Nonnull String entityRoutingProperty, @Nonnull String messageRoutingProperty) {
        this.metamodel = Objects.requireNonNull(metamodel, "The metamodel may not be null.");
        this.entityRoutingProperty = Objects.requireNonNull(entityRoutingProperty, "The entityRoutingProperty may not be null.");
        this.messageRoutingProperty = Objects.requireNonNull(messageRoutingProperty, "The messageRoutingProperty may not be null.");
        this.messageRoutingPropertyCache = new ConcurrentHashMap<MessageType, Property<Object>>();
        this.entityRoutingPropertyCache = new ConcurrentHashMap();
    }

    public boolean matches(@Nonnull E entity, @Nonnull Message<?> message) {
        Class<?> payloadType = this.metamodel.getExpectedRepresentation(message.type().qualifiedName());
        if (payloadType == null) {
            return false;
        }
        Property routingProperty = this.messageRoutingPropertyCache.computeIfAbsent(message.type(), unused -> this.resolveProperty(payloadType));
        if (routingProperty == null) {
            throw new UnknownRoutingKeyException(String.format("Message of type [%s] doesn't have a property matching the routing key [%s] necessary to route to child entity of type [%s]", message.type(), this.messageRoutingProperty, this.metamodel.entityType()));
        }
        Object convertedPayload = this.metamodel.converter().convert(message.getPayload(), payloadType);
        Object routingValue = routingProperty.getValue(convertedPayload);
        return this.matchesInstance(entity, routingValue);
    }

    private Property<Object> resolveProperty(Class<?> runtimeType) {
        return PropertyAccessStrategy.getProperty(runtimeType, (String)this.messageRoutingProperty);
    }

    private boolean matchesInstance(E candidate, Object routingValue) {
        Property objectProperty = this.entityRoutingPropertyCache.computeIfAbsent(candidate.getClass(), c -> PropertyAccessStrategy.getProperty(this.metamodel.entityType(), (String)this.entityRoutingProperty));
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("No value found for routing key property [%s] found in entity type [%s]", this.entityRoutingProperty, candidate.getClass()));
        }
        Object identifier = objectProperty.getValue(candidate);
        return Objects.equals(routingValue, identifier);
    }
}

