/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.configuration;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.common.FutureUtils;
import org.axonframework.configuration.BaseModule;
import org.axonframework.configuration.ComponentBuilder;
import org.axonframework.configuration.ComponentDefinition;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.modelling.SimpleStateManager;
import org.axonframework.modelling.StateManager;
import org.axonframework.modelling.command.StatefulCommandHandler;
import org.axonframework.modelling.command.StatefulCommandHandlingComponent;
import org.axonframework.modelling.configuration.EntityModule;
import org.axonframework.modelling.configuration.StatefulCommandHandlingModule;

class SimpleStatefulCommandHandlingModule
extends BaseModule<SimpleStatefulCommandHandlingModule>
implements StatefulCommandHandlingModule,
StatefulCommandHandlingModule.SetupPhase,
StatefulCommandHandlingModule.CommandHandlerPhase,
StatefulCommandHandlingModule.EntityPhase {
    private final String moduleName;
    private final String statefulCommandHandlingComponentName;
    private final Map<String, EntityModule<?, ?>> entityModules;
    private final Map<QualifiedName, ComponentBuilder<StatefulCommandHandler>> handlerBuilders;
    private final List<ComponentBuilder<CommandHandlingComponent>> handlingComponentBuilders;

    SimpleStatefulCommandHandlingModule(@Nonnull String moduleName) {
        super(moduleName);
        this.moduleName = Objects.requireNonNull(moduleName, "The module name cannot be null.");
        this.statefulCommandHandlingComponentName = "StatefulCommandHandlingComponent[" + moduleName + "]";
        this.entityModules = new HashMap();
        this.handlerBuilders = new HashMap<QualifiedName, ComponentBuilder<StatefulCommandHandler>>();
        this.handlingComponentBuilders = new ArrayList<ComponentBuilder<CommandHandlingComponent>>();
    }

    @Override
    public StatefulCommandHandlingModule.CommandHandlerPhase commandHandlers() {
        return this;
    }

    @Override
    public StatefulCommandHandlingModule.CommandHandlerPhase commandHandler(@Nonnull QualifiedName commandName, @Nonnull ComponentBuilder<StatefulCommandHandler> commandHandlerBuilder) {
        this.handlerBuilders.put(Objects.requireNonNull(commandName, "The command name cannot be null."), Objects.requireNonNull(commandHandlerBuilder, "The command handler builder cannot be null."));
        return this;
    }

    @Override
    public StatefulCommandHandlingModule.CommandHandlerPhase commandHandlingComponent(@Nonnull ComponentBuilder<CommandHandlingComponent> handlingComponentBuilder) {
        this.handlingComponentBuilders.add(Objects.requireNonNull(handlingComponentBuilder, "The command handling component builder cannot be null."));
        return this;
    }

    @Override
    public StatefulCommandHandlingModule.EntityPhase entities() {
        return this;
    }

    @Override
    public <I, E> StatefulCommandHandlingModule.EntityPhase entity(@Nonnull EntityModule<I, E> entityModule) {
        Objects.requireNonNull(entityModule, "The entity module cannot be null.");
        this.entityModules.put(entityModule.entityName(), entityModule);
        return this;
    }

    public StatefulCommandHandlingModule build() {
        this.registerStateManager();
        this.registerStatefulCommandHandlingComponent();
        this.registerEntityModules();
        return this;
    }

    private void registerEntityModules() {
        this.componentRegistry(cr -> this.entityModules.values().forEach(arg_0 -> ((ComponentRegistry)cr).registerModule(arg_0)));
    }

    private void registerStateManager() {
        this.componentRegistry(cr -> cr.registerComponent(StateManager.class, config -> SimpleStateManager.named("StateManager[" + this.moduleName + "]")));
    }

    private void registerStatefulCommandHandlingComponent() {
        this.componentRegistry(cr -> cr.registerComponent(this.getStatefulCommandHandlingComponentComponentDefinition()));
    }

    private ComponentDefinition<StatefulCommandHandlingComponent> getStatefulCommandHandlingComponentComponentDefinition() {
        return ComponentDefinition.ofTypeAndName(StatefulCommandHandlingComponent.class, (String)this.statefulCommandHandlingComponentName).withBuilder(c -> {
            StatefulCommandHandlingComponent statefulCommandHandler = StatefulCommandHandlingComponent.create(this.statefulCommandHandlingComponentName, (StateManager)c.getComponent(StateManager.class));
            this.handlingComponentBuilders.forEach(handlingComponent -> statefulCommandHandler.subscribe((CommandHandlingComponent)handlingComponent.build(c)));
            this.handlerBuilders.forEach((key, value) -> statefulCommandHandler.subscribe((QualifiedName)key, (StatefulCommandHandler)value.build(c)));
            return statefulCommandHandler;
        }).onStart(0, (configuration, component) -> {
            ((CommandBus)configuration.getComponent(CommandBus.class)).subscribe((CommandHandlingComponent)configuration.getComponent(StatefulCommandHandlingComponent.class, this.statefulCommandHandlingComponentName));
            return FutureUtils.emptyCompletedFuture();
        });
    }
}

