/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Consumer;
import org.axonframework.configuration.ApplicationConfigurer;
import org.axonframework.configuration.AxonConfiguration;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.configuration.MessagingConfigurer;
import org.axonframework.configuration.ModuleBuilder;
import org.axonframework.modelling.configuration.ModellingConfigurationDefaults;
import org.axonframework.modelling.configuration.StatefulCommandHandlingModule;

public class ModellingConfigurer
implements ApplicationConfigurer {
    private final MessagingConfigurer delegate;

    public static ModellingConfigurer create() {
        return ModellingConfigurer.enhance(MessagingConfigurer.create());
    }

    public static ModellingConfigurer enhance(@Nonnull MessagingConfigurer messagingConfigurer) {
        return new ModellingConfigurer(messagingConfigurer).componentRegistry(cr -> cr.registerEnhancer((ConfigurationEnhancer)new ModellingConfigurationDefaults()));
    }

    public ModellingConfigurer(@Nonnull MessagingConfigurer delegate) {
        Objects.requireNonNull(delegate, "The delegate MessagingConfigurer may not be null");
        this.delegate = delegate;
    }

    public ModellingConfigurer registerStatefulCommandHandlingModule(ModuleBuilder<StatefulCommandHandlingModule> moduleBuilder) {
        this.delegate.componentRegistry(cr -> cr.registerModule(moduleBuilder.build()));
        return this;
    }

    public ModellingConfigurer messaging(@Nonnull Consumer<MessagingConfigurer> configurerTask) {
        configurerTask.accept(this.delegate);
        return this;
    }

    public ModellingConfigurer componentRegistry(@Nonnull Consumer<ComponentRegistry> componentRegistrar) {
        this.delegate.componentRegistry(componentRegistrar);
        return this;
    }

    public ModellingConfigurer lifecycleRegistry(@Nonnull Consumer<LifecycleRegistry> lifecycleRegistrar) {
        this.delegate.lifecycleRegistry(lifecycleRegistrar);
        return this;
    }

    public AxonConfiguration build() {
        return this.delegate.build();
    }
}

