/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command.inspection;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.annotation.CommandMessageHandlingMember;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.modelling.command.inspection.ChildEntity;
import org.axonframework.modelling.command.inspection.ChildForwardingCommandMessageHandlingMember;
import org.axonframework.modelling.command.inspection.EntityModel;

public class AnnotatedChildEntity<P, C>
implements ChildEntity<P> {
    private final EntityModel<C> entityModel;
    private final List<MessageHandlingMember<? super P>> commandHandlers;
    private final BiFunction<EventMessage<?>, P, Stream<C>> eventTargetResolver;

    public AnnotatedChildEntity(EntityModel<C> entityModel, boolean forwardCommands, BiFunction<CommandMessage<?>, P, C> commandTargetResolver, BiFunction<EventMessage<?>, P, Stream<C>> eventTargetResolver) {
        this.entityModel = entityModel;
        this.eventTargetResolver = eventTargetResolver;
        this.commandHandlers = new ArrayList<MessageHandlingMember<? super P>>();
        if (forwardCommands) {
            entityModel.commandHandlers(entityModel.entityClass()).filter(eh -> eh.unwrap(CommandMessageHandlingMember.class).isPresent()).map(childHandler -> new ChildForwardingCommandMessageHandlingMember(entityModel.commandHandlerInterceptors(entityModel.entityClass()).collect(Collectors.toList()), childHandler, commandTargetResolver)).forEach(this.commandHandlers::add);
        }
    }

    @Override
    public void publish(EventMessage<?> msg, P declaringInstance) {
        this.eventTargetResolver.apply(msg, declaringInstance).collect(Collectors.toList()).forEach(target -> this.entityModel.publish(msg, target));
    }

    @Override
    public List<MessageHandlingMember<? super P>> commandHandlers() {
        return this.commandHandlers;
    }
}

