/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga;

import javax.annotation.Nonnull;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.WrappedMessageHandlingMember;
import org.axonframework.modelling.saga.AssociationResolver;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.SagaCreationPolicy;

public class SagaMethodMessageHandlingMember<T>
extends WrappedMessageHandlingMember<T> {
    private final MessageHandlingMember<T> delegate;
    private final SagaCreationPolicy creationPolicy;
    private final String associationKey;
    private final String associationPropertyName;
    private final AssociationResolver associationResolver;

    public SagaMethodMessageHandlingMember(MessageHandlingMember<T> delegate, SagaCreationPolicy creationPolicy, String associationKey, String associationPropertyName, AssociationResolver associationResolver) {
        super(delegate);
        this.delegate = delegate;
        this.creationPolicy = creationPolicy;
        this.associationKey = associationKey;
        this.associationPropertyName = associationPropertyName;
        this.associationResolver = associationResolver;
    }

    public AssociationValue getAssociationValue(EventMessage<?> eventMessage) {
        if (this.associationResolver == null) {
            return null;
        }
        Object associationValue = this.associationResolver.resolve(this.associationPropertyName, eventMessage, this);
        return new AssociationValue(this.associationKey, associationValue == null ? null : associationValue.toString());
    }

    public Object handleSync(@Nonnull Message<?> message, T target) throws Exception {
        return this.delegate.handleSync(message, target);
    }

    public SagaCreationPolicy getCreationPolicy() {
        return this.creationPolicy;
    }
}

