/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.configuration;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.configuration.BaseModule;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.modelling.SimpleStateManager;
import org.axonframework.modelling.StateManager;
import org.axonframework.modelling.command.StatefulCommandHandler;
import org.axonframework.modelling.command.StatefulCommandHandlingComponent;
import org.axonframework.modelling.configuration.EntityBuilder;
import org.axonframework.modelling.configuration.StatefulCommandHandlingModule;
import org.axonframework.modelling.repository.Repository;

class DefaultStatefulCommandHandlingModule
extends BaseModule<DefaultStatefulCommandHandlingModule>
implements StatefulCommandHandlingModule,
StatefulCommandHandlingModule.SetupPhase,
StatefulCommandHandlingModule.CommandHandlerPhase,
StatefulCommandHandlingModule.EntityPhase {
    private final String moduleName;
    private final String statefulCommandHandlingComponentName;
    private final Map<String, EntityBuilder<?, ?>> entityBuilders;
    private final Map<QualifiedName, ComponentFactory<StatefulCommandHandler>> handlerFactories;
    private final List<ComponentFactory<CommandHandlingComponent>> handlingComponentFactories;

    DefaultStatefulCommandHandlingModule(@Nonnull String moduleName) {
        super(moduleName);
        this.moduleName = Objects.requireNonNull(moduleName, "The module name cannot be null.");
        this.statefulCommandHandlingComponentName = "StatefulCommandHandlingComponent[" + moduleName + "]";
        this.entityBuilders = new HashMap();
        this.handlerFactories = new HashMap<QualifiedName, ComponentFactory<StatefulCommandHandler>>();
        this.handlingComponentFactories = new ArrayList<ComponentFactory<CommandHandlingComponent>>();
    }

    @Override
    public StatefulCommandHandlingModule.CommandHandlerPhase commandHandlers() {
        return this;
    }

    @Override
    public StatefulCommandHandlingModule.CommandHandlerPhase commandHandler(@Nonnull QualifiedName commandName, @Nonnull ComponentFactory<StatefulCommandHandler> commandHandlerBuilder) {
        this.handlerFactories.put(Objects.requireNonNull(commandName, "The command name cannot be null."), Objects.requireNonNull(commandHandlerBuilder, "The command handler builder cannot be null."));
        return this;
    }

    @Override
    public StatefulCommandHandlingModule.CommandHandlerPhase commandHandlingComponent(@Nonnull ComponentFactory<CommandHandlingComponent> handlingComponentBuilder) {
        this.handlingComponentFactories.add(Objects.requireNonNull(handlingComponentBuilder, "The command handling component builder cannot be null."));
        return this;
    }

    @Override
    public StatefulCommandHandlingModule.EntityPhase entities() {
        return this;
    }

    @Override
    public <I, E> StatefulCommandHandlingModule.EntityPhase entity(@Nonnull EntityBuilder<I, E> entityBuilder) {
        Objects.requireNonNull(entityBuilder, "The entity builder cannot be null.");
        this.entityBuilders.put(entityBuilder.entityName(), entityBuilder);
        return this;
    }

    public StatefulCommandHandlingModule build() {
        this.registerRepositories();
        this.componentRegistry(cr -> cr.registerComponent(StateManager.class, this::stateManagerFactory));
        this.registerCommandHandlers();
        return this;
    }

    private void registerRepositories() {
        this.entityBuilders.forEach((name, entityBuilder) -> this.componentRegistry(cr -> cr.registerComponent(Repository.class, name, entityBuilder.repository())));
    }

    private SimpleStateManager stateManagerFactory(Configuration config) {
        SimpleStateManager.Builder managerBuilder = SimpleStateManager.builder("StateManager[" + this.moduleName + "]");
        for (String repositoryName : this.entityBuilders.keySet()) {
            managerBuilder.register((Repository)config.getComponent(Repository.class, repositoryName));
        }
        return managerBuilder.build();
    }

    private void registerCommandHandlers() {
        this.componentRegistry(cr -> cr.registerComponent(StatefulCommandHandlingComponent.class, this.statefulCommandHandlingComponentName, c -> {
            StatefulCommandHandlingComponent statefulCommandHandler = StatefulCommandHandlingComponent.create(this.statefulCommandHandlingComponentName, (StateManager)c.getComponent(StateManager.class));
            this.handlerFactories.forEach((key, value) -> statefulCommandHandler.subscribe((QualifiedName)key, (StatefulCommandHandler)value.build(c)));
            this.handlingComponentFactories.forEach(handlingComponent -> statefulCommandHandler.subscribe((CommandHandlingComponent)handlingComponent.build(c)));
            return statefulCommandHandler;
        }));
    }

    public Configuration build(@Nonnull Configuration parent, @Nonnull LifecycleRegistry lifecycleRegistry) {
        lifecycleRegistry.onStart(0, c -> ((CommandBus)c.getComponent(CommandBus.class)).subscribe((CommandHandlingComponent)c.getComponent(StatefulCommandHandlingComponent.class, this.statefulCommandHandlingComponentName)));
        return super.build(parent, lifecycleRegistry);
    }
}

