/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.modelling.SimpleRepository;
import org.axonframework.modelling.SimpleRepositoryEntityLoader;
import org.axonframework.modelling.SimpleRepositoryEntityPersister;
import org.axonframework.modelling.configuration.StateBasedEntityBuilder;
import org.axonframework.modelling.repository.Repository;

class DefaultStateBasedEntityBuilder<I, E>
implements StateBasedEntityBuilder<I, E>,
StateBasedEntityBuilder.RepositoryPhase<I, E>,
StateBasedEntityBuilder.PersisterPhase<I, E> {
    private final Class<I> idType;
    private final Class<E> entityType;
    private ComponentFactory<SimpleRepositoryEntityLoader<I, E>> loaderFactory;
    private ComponentFactory<SimpleRepositoryEntityPersister<I, E>> persisterFactory;
    private ComponentFactory<Repository<I, E>> repositoryFactory;

    DefaultStateBasedEntityBuilder(@Nonnull Class<I> idType, @Nonnull Class<E> entityType) {
        this.idType = Objects.requireNonNull(idType, "The identifier type cannot be null.");
        this.entityType = Objects.requireNonNull(entityType, "The entity type cannot be null.");
    }

    @Override
    public StateBasedEntityBuilder<I, E> persister(@Nonnull ComponentFactory<SimpleRepositoryEntityPersister<I, E>> persister) {
        this.persisterFactory = Objects.requireNonNull(persister, "The repository persister factory cannot be null.");
        return this;
    }

    @Override
    public StateBasedEntityBuilder.PersisterPhase<I, E> loader(@Nonnull ComponentFactory<SimpleRepositoryEntityLoader<I, E>> loader) {
        this.loaderFactory = Objects.requireNonNull(loader, "The repository loader factory cannot be null.");
        return this;
    }

    @Override
    public StateBasedEntityBuilder<I, E> repository(@Nonnull ComponentFactory<Repository<I, E>> repository) {
        this.repositoryFactory = Objects.requireNonNull(repository, "The repository factory cannot be null.");
        return this;
    }

    @Override
    public String entityName() {
        return this.entityType.getSimpleName() + "#" + this.idType.getSimpleName();
    }

    @Override
    public ComponentFactory<Repository<I, E>> repository() {
        return this.repositoryFactory != null ? this.repositoryFactory : c -> new SimpleRepository<I, E>(this.idType, this.entityType, (SimpleRepositoryEntityLoader)this.loaderFactory.build(c), (SimpleRepositoryEntityPersister)this.persisterFactory.build(c));
    }
}

