/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command.inspection;

import java.lang.reflect.Member;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.property.Property;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.modelling.command.ForwardingMode;
import org.axonframework.modelling.command.inspection.AbstractChildEntityDefinition;
import org.axonframework.modelling.command.inspection.EntityModel;

public class AggregateMemberAnnotatedChildEntityCollectionDefinition
extends AbstractChildEntityDefinition {
    @Override
    protected boolean isMemberTypeSupported(Member member) {
        try {
            return Iterable.class.isAssignableFrom(ReflectionUtils.getMemberValueType((Member)member));
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    protected <T> EntityModel<Object> extractChildEntityModel(EntityModel<T> declaringEntity, Map<String, Object> attributes, Member member) {
        Class entityType = (Class)attributes.get("type");
        if (Void.class.equals((Object)entityType)) {
            entityType = (Class)ReflectionUtils.resolveMemberGenericType((Member)member, (int)0).orElseThrow(() -> new AxonConfigurationException(String.format("Unable to resolve entity type of member [%s]. Please provide type explicitly in @AggregateMember annotation.", ReflectionUtils.getMemberGenericString((Member)member))));
        }
        if (entityType.isInterface()) {
            throw new AxonConfigurationException("Aggregate Member type should be a concrete implementation instead of [" + String.valueOf(entityType) + "].");
        }
        return declaringEntity.modelOf(entityType);
    }

    @Override
    protected <T> Object resolveCommandTarget(CommandMessage<?> msg, T parent, Member member, EntityModel<Object> childEntityModel) {
        Map<String, Property<Object>> commandHandlerRoutingKeys = this.extractCommandHandlerRoutingKeys(member, childEntityModel);
        Object routingValue = commandHandlerRoutingKeys.get(msg.type().name()).getValue(msg.getPayload());
        Iterable memberValue = (Iterable)ReflectionUtils.getMemberValue((Member)member, parent);
        return StreamSupport.stream(memberValue.spliterator(), false).filter(i -> Objects.equals(routingValue, childEntityModel.getIdentifier(i))).findFirst().orElse(null);
    }

    @Override
    protected <T> Stream<Object> resolveEventTargets(EventMessage message, T parentEntity, Member member, ForwardingMode eventForwardingMode) {
        Iterable memberValue = (Iterable)ReflectionUtils.getMemberValue((Member)member, parentEntity);
        return memberValue == null ? Stream.empty() : eventForwardingMode.filterCandidates(message, StreamSupport.stream(memberValue.spliterator(), false));
    }
}

