/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.annotation;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.common.Assert;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.annotation.NullEntityIdInPayloadException;
import org.axonframework.modelling.annotation.TargetEntityIdMemberMismatchException;
import org.axonframework.modelling.command.EntityIdResolver;

public class PropertyBasedEntityIdResolver
implements EntityIdResolver<Object> {
    private final Map<Class<?>, Property<Object>> propertyCache = new ConcurrentHashMap();
    private final String property;

    public PropertyBasedEntityIdResolver(@Nonnull String property) {
        Assert.nonEmpty((String)property, (String)"Property cannot be empty or null");
        this.property = property;
    }

    @Override
    @Nonnull
    public Object resolve(@Nonnull Message<?> message, @Nonnull ProcessingContext context) {
        Object payload = message.getPayload();
        Class<?> payloadClass = payload.getClass();
        Property property = this.propertyCache.computeIfAbsent(payloadClass, this::getObjectProperty);
        Object value = property.getValue(payload);
        if (value == null) {
            throw new NullEntityIdInPayloadException(payloadClass);
        }
        return value;
    }

    private Property<Object> getObjectProperty(Class<?> payloadClass) {
        Property foundProperty = PropertyAccessStrategy.getProperty(payloadClass, (String)this.property);
        if (foundProperty == null) {
            throw new TargetEntityIdMemberMismatchException(this.property, payloadClass);
        }
        return foundProperty;
    }
}

