/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling;

import jakarta.annotation.Nonnull;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.ConflictingRepositoryAlreadyRegisteredException;
import org.axonframework.modelling.LoadedEntityNotOfExpectedTypeException;
import org.axonframework.modelling.MissingRepositoryException;
import org.axonframework.modelling.SimpleRepository;
import org.axonframework.modelling.SimpleRepositoryEntityLoader;
import org.axonframework.modelling.SimpleRepositoryEntityPersister;
import org.axonframework.modelling.StateManager;
import org.axonframework.modelling.repository.ManagedEntity;
import org.axonframework.modelling.repository.Repository;

public class SimpleStateManager
implements StateManager,
DescribableComponent {
    private final String name;
    private final List<Repository<?, ?>> repositories;

    public static Builder builder(@Nonnull String name) {
        BuilderUtils.assertNonBlank((String)name, (String)"Name may not be blank");
        return new Builder(name);
    }

    private SimpleStateManager(@Nonnull Builder builder) {
        this.name = builder.name;
        this.repositories = builder.repositories;
    }

    @Override
    @Nonnull
    public <I, T> CompletableFuture<ManagedEntity<I, T>> loadManagedEntity(@Nonnull Class<T> entityType, @Nonnull I id, @Nonnull ProcessingContext context) {
        return this.repositories.stream().filter(r -> r.entityType().isAssignableFrom(entityType)).filter(r -> r.idType().isAssignableFrom(id.getClass())).map(r -> r).findFirst().orElseThrow(() -> new MissingRepositoryException(id.getClass(), entityType)).load(id, context).thenApply(me -> {
            if (me.entity() != null && !entityType.isInstance(me.entity())) {
                throw new LoadedEntityNotOfExpectedTypeException(me.entity().getClass(), entityType);
            }
            return me;
        });
    }

    @Override
    public Set<Class<?>> registeredEntities() {
        return this.repositories.stream().map(Repository::entityType).collect(Collectors.toSet());
    }

    @Override
    public Set<Class<?>> registeredIdsFor(@Nonnull Class<?> entityType) {
        return this.repositories.stream().filter(r -> r.entityType().equals(entityType)).map(Repository::idType).collect(Collectors.toSet());
    }

    @Override
    public <I, T> Repository<I, T> repository(@Nonnull Class<T> entityType, @Nonnull Class<I> idType) {
        return this.repositories.stream().filter(r -> r.entityType().equals(entityType)).filter(r -> r.idType().equals(idType)).findFirst().orElse(null);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("name", this.name);
        descriptor.describeProperty("repositories", this.repositories);
    }

    public static class Builder {
        private final String name;
        private final List<Repository<?, ?>> repositories = new LinkedList();

        private Builder(String name) {
            BuilderUtils.assertNonBlank((String)name, (String)"Name may not be blank");
            this.name = name;
        }

        public <I, T> Builder register(Repository<I, T> repository) {
            Optional<Repository> registeredRepository = this.repositories.stream().filter(r -> this.match((Repository<?, ?>)r, repository)).findFirst();
            if (registeredRepository.isPresent()) {
                throw new ConflictingRepositoryAlreadyRegisteredException(repository, registeredRepository.get());
            }
            this.repositories.add(repository);
            return this;
        }

        public <I, T> Builder register(Class<I> idType, Class<T> entityType, SimpleRepositoryEntityLoader<I, T> loader, SimpleRepositoryEntityPersister<I, T> persister) {
            return this.register(new SimpleRepository<I, T>(idType, entityType, loader, persister));
        }

        public SimpleStateManager build() {
            return new SimpleStateManager(this);
        }

        private boolean match(Repository<?, ?> repositoryOne, Repository<?, ?> repositoryTwo) {
            return Builder.matchesBasedOnEntityType(repositoryOne, repositoryTwo) && Builder.matchesBasedOnIdType(repositoryOne, repositoryTwo);
        }

        private static boolean matchesBasedOnIdType(Repository<?, ?> repositoryOne, Repository<?, ?> repositoryTwo) {
            return repositoryOne.idType().isAssignableFrom(repositoryTwo.idType()) || repositoryTwo.idType().isAssignableFrom(repositoryOne.idType());
        }

        private static boolean matchesBasedOnEntityType(Repository<?, ?> repositoryOne, Repository<?, ?> repositoryTwo) {
            return repositoryOne.entityType().isAssignableFrom(repositoryTwo.entityType()) || repositoryTwo.entityType().isAssignableFrom(repositoryOne.entityType());
        }
    }
}

