/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.axonframework.modelling.saga.repository.jdbc.GenericSagaSqlSchema;
import org.axonframework.modelling.saga.repository.jdbc.SagaSchema;

public class PostgresSagaSqlSchema
extends GenericSagaSqlSchema {
    private boolean exclusiveLoad = false;

    public PostgresSagaSqlSchema() {
    }

    public PostgresSagaSqlSchema(SagaSchema sagaSchema) {
        super(sagaSchema);
    }

    @Override
    public PreparedStatement sql_createTableAssocValueEntry(Connection conn) throws SQLException {
        String sql = "CREATE TABLE IF NOT EXISTS " + this.sagaSchema().associationValueEntryTable() + " (\n        id bigserial NOT NULL,\n        " + this.sagaSchema.associationKeyColumn() + " VARCHAR(255),\n        " + this.sagaSchema.associationValueColumn() + " VARCHAR(255),\n        " + this.sagaSchema.sagaIdColumn() + " VARCHAR(255),\n        " + this.sagaSchema.sagaTypeColumn() + " VARCHAR(255),\n        PRIMARY KEY (id)\n    );\n";
        return conn.prepareStatement(sql);
    }

    @Override
    public PreparedStatement sql_createTableSagaEntry(Connection conn) throws SQLException {
        return conn.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.sagaSchema().sagaEntryTable() + " (\n        " + this.sagaSchema.sagaIdColumn() + " VARCHAR(255) NOT NULL,\n        " + this.sagaSchema.revisionColumn() + " VARCHAR(255),\n        " + this.sagaSchema.sagaTypeColumn() + " VARCHAR(255),\n        " + this.sagaSchema.serializedSagaColumn() + " bytea,\n        PRIMARY KEY (" + this.sagaSchema.sagaIdColumn() + ")\n    );");
    }

    @Override
    public PreparedStatement sql_loadSaga(Connection connection, String sagaId) throws SQLException {
        if (!this.exclusiveLoad) {
            return super.sql_loadSaga(connection, sagaId);
        }
        String sql = "SELECT " + this.sagaSchema.serializedSagaColumn() + ", " + this.sagaSchema.sagaTypeColumn() + ", " + this.sagaSchema.revisionColumn() + " FROM " + this.sagaSchema().sagaEntryTable() + " WHERE " + this.sagaSchema.sagaIdColumn() + " = ? FOR UPDATE";
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.setString(1, sagaId);
        return preparedStatement;
    }

    public void setExclusiveLoad(boolean exclusiveLoad) {
        this.exclusiveLoad = exclusiveLoad;
    }
}

