/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.CollectionUtils;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.modelling.saga.AnnotatedSaga;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.ResourceInjector;
import org.axonframework.modelling.saga.Saga;
import org.axonframework.modelling.saga.metamodel.AnnotationSagaMetaModelFactory;
import org.axonframework.modelling.saga.metamodel.SagaModel;
import org.axonframework.modelling.saga.repository.LockingSagaRepository;
import org.axonframework.modelling.saga.repository.NoResourceInjector;
import org.axonframework.modelling.saga.repository.SagaCreationException;
import org.axonframework.modelling.saga.repository.SagaStore;

public class AnnotatedSagaRepository<T>
extends LockingSagaRepository<T> {
    private final Class<T> sagaType;
    private final SagaStore<? super T> sagaStore;
    private final SagaModel<T> sagaModel;
    private final ResourceInjector resourceInjector;
    private final Map<String, AnnotatedSaga<T>> managedSagas;
    private final String unsavedSagasResourceKey;

    protected AnnotatedSagaRepository(Builder<T> builder) {
        super(builder);
        this.sagaType = ((Builder)builder).sagaType;
        this.sagaModel = builder.buildSagaModel();
        this.sagaStore = ((Builder)builder).sagaStore;
        this.resourceInjector = ((Builder)builder).resourceInjector;
        this.managedSagas = new ConcurrentHashMap<String, AnnotatedSaga<T>>();
        this.unsavedSagasResourceKey = "Repository[" + this.sagaType.getSimpleName() + "]/UnsavedSagas";
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Override
    public AnnotatedSaga<T> doLoad(String sagaIdentifier) {
        UnitOfWork unitOfWork = CurrentUnitOfWork.get();
        UnitOfWork processRoot = unitOfWork.root();
        AnnotatedSaga loadedSaga = this.managedSagas.computeIfAbsent(sagaIdentifier, id -> {
            AnnotatedSaga<T> result = this.doLoadSaga(sagaIdentifier);
            if (result != null) {
                processRoot.onCleanup(u -> this.managedSagas.remove(id));
            }
            return result;
        });
        if (loadedSaga != null && this.unsavedSagaResource(processRoot).add(sagaIdentifier)) {
            unitOfWork.onPrepareCommit(u -> {
                this.unsavedSagaResource(processRoot).remove(sagaIdentifier);
                this.commit(loadedSaga);
            });
        }
        return loadedSaga;
    }

    @Override
    public AnnotatedSaga<T> doCreateInstance(String sagaIdentifier, Supplier<T> sagaFactory) {
        try {
            UnitOfWork unitOfWork = CurrentUnitOfWork.get();
            UnitOfWork processRoot = unitOfWork.root();
            T sagaRoot = sagaFactory.get();
            this.resourceInjector.injectResources(sagaRoot);
            AnnotatedSaga<T> saga = new AnnotatedSaga<T>(sagaIdentifier, Collections.emptySet(), sagaRoot, this.sagaModel);
            this.unsavedSagaResource(processRoot).add(sagaIdentifier);
            unitOfWork.onPrepareCommit(u -> {
                if (saga.isActive()) {
                    this.storeSaga(saga);
                    saga.getAssociationValues().commit();
                    this.unsavedSagaResource(processRoot).remove(sagaIdentifier);
                }
            });
            this.managedSagas.put(sagaIdentifier, saga);
            processRoot.onCleanup(u -> this.managedSagas.remove(sagaIdentifier));
            return saga;
        }
        catch (Exception e) {
            throw new SagaCreationException("An error occurred while attempting to create a new managed instance", e);
        }
    }

    protected Set<String> unsavedSagaResource(UnitOfWork<?> unitOfWork) {
        return (Set)unitOfWork.getOrComputeResource(this.unsavedSagasResourceKey, i -> new HashSet());
    }

    protected void commit(AnnotatedSaga<T> saga) {
        if (!saga.isActive()) {
            this.deleteSaga(saga);
        } else {
            this.updateSaga(saga);
            saga.getAssociationValues().commit();
        }
    }

    @Override
    public Set<String> find(AssociationValue associationValue) {
        TreeSet<String> sagasFound = new TreeSet<String>();
        sagasFound.addAll(this.managedSagas.values().stream().filter(saga -> saga.getAssociationValues().contains(associationValue)).map(Saga::getSagaIdentifier).collect(Collectors.toList()));
        sagasFound.addAll(this.sagaStore.findSagas(this.sagaType, associationValue));
        return sagasFound;
    }

    protected void deleteSaga(AnnotatedSaga<T> saga) {
        Set associationValues = (Set)CollectionUtils.merge(saga.getAssociationValues().asSet(), saga.getAssociationValues().removedAssociations(), HashSet::new);
        this.sagaStore.deleteSaga(this.sagaType, saga.getSagaIdentifier(), associationValues);
    }

    protected void updateSaga(AnnotatedSaga<T> saga) {
        this.sagaStore.updateSaga(this.sagaType, saga.getSagaIdentifier(), saga.root(), saga.getAssociationValues());
    }

    protected void storeSaga(AnnotatedSaga<T> saga) {
        this.sagaStore.insertSaga(this.sagaType, saga.getSagaIdentifier(), saga.root(), saga.getAssociationValues().asSet());
    }

    protected AnnotatedSaga<T> doLoadSaga(String sagaIdentifier) {
        SagaStore.Entry<T> entry = this.sagaStore.loadSaga(this.sagaType, sagaIdentifier);
        if (entry != null) {
            T saga = entry.saga();
            this.resourceInjector.injectResources(saga);
            return new AnnotatedSaga<T>(sagaIdentifier, entry.associationValues(), saga, this.sagaModel);
        }
        return null;
    }

    public static class Builder<T>
    extends LockingSagaRepository.Builder<T> {
        private Class<T> sagaType;
        private ParameterResolverFactory parameterResolverFactory;
        private HandlerDefinition handlerDefinition;
        private SagaModel<T> sagaModel;
        private SagaStore<? super T> sagaStore;
        private ResourceInjector resourceInjector = NoResourceInjector.INSTANCE;

        @Override
        public Builder<T> lockFactory(LockFactory lockFactory) {
            super.lockFactory(lockFactory);
            return this;
        }

        public Builder<T> sagaType(Class<T> sagaType) {
            BuilderUtils.assertNonNull(sagaType, (String)"The sagaType may not be null");
            this.sagaType = sagaType;
            return this;
        }

        public Builder<T> parameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
            BuilderUtils.assertNonNull((Object)parameterResolverFactory, (String)"ParameterResolverFactory may not be null");
            this.parameterResolverFactory = parameterResolverFactory;
            return this;
        }

        public Builder<T> handlerDefinition(HandlerDefinition handlerDefinition) {
            BuilderUtils.assertNonNull((Object)handlerDefinition, (String)"HandlerDefinition may not be null");
            this.handlerDefinition = handlerDefinition;
            return this;
        }

        public Builder<T> sagaModel(SagaModel<T> sagaModel) {
            BuilderUtils.assertNonNull(sagaModel, (String)"SagaModel may not be null");
            this.sagaModel = sagaModel;
            return this;
        }

        public Builder<T> sagaStore(SagaStore<? super T> sagaStore) {
            BuilderUtils.assertNonNull(sagaStore, (String)"SagaStore may not be null");
            this.sagaStore = sagaStore;
            return this;
        }

        public Builder<T> resourceInjector(ResourceInjector resourceInjector) {
            BuilderUtils.assertNonNull((Object)resourceInjector, (String)"ResourceInjector may not be null");
            this.resourceInjector = resourceInjector;
            return this;
        }

        public AnnotatedSagaRepository<T> build() {
            return new AnnotatedSagaRepository(this);
        }

        protected SagaModel<T> buildSagaModel() {
            if (this.sagaModel == null) {
                return this.inspectSagaModel();
            }
            return this.sagaModel;
        }

        private SagaModel<T> inspectSagaModel() {
            if (this.parameterResolverFactory == null && this.handlerDefinition == null) {
                return new AnnotationSagaMetaModelFactory().modelOf(this.sagaType);
            }
            if (this.parameterResolverFactory != null && this.handlerDefinition == null) {
                return new AnnotationSagaMetaModelFactory(this.parameterResolverFactory).modelOf(this.sagaType);
            }
            return new AnnotationSagaMetaModelFactory(this.parameterResolverFactory, this.handlerDefinition).modelOf(this.sagaType);
        }

        @Override
        protected void validate() throws AxonConfigurationException {
            super.validate();
            BuilderUtils.assertNonNull(this.sagaType, (String)"The sagaType is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.sagaStore, (String)"The SagaStore is a hard requirement and should be provided");
        }
    }
}

