/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.caching.Cache;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.AssociationValues;
import org.axonframework.modelling.saga.repository.SagaStore;

public class CachingSagaStore<T>
implements SagaStore<T> {
    private final SagaStore<T> delegate;
    private final Cache associationsCache;
    private final Cache sagaCache;

    protected CachingSagaStore(Builder<T> builder) {
        builder.validate();
        this.delegate = ((Builder)builder).delegateSagaStore;
        this.associationsCache = ((Builder)builder).associationsCache;
        this.sagaCache = ((Builder)builder).sagaCache;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Override
    public Set<String> findSagas(Class<? extends T> sagaType, AssociationValue associationValue) {
        String key = this.cacheKey(associationValue, sagaType);
        return (Set)this.associationsCache.computeIfAbsent((Object)key, () -> Collections.synchronizedSet(this.delegate.findSagas(sagaType, associationValue)));
    }

    @Override
    public <S extends T> SagaStore.Entry<S> loadSaga(Class<S> sagaType, String sagaIdentifier) {
        SagaStore.Entry<S> saga = (SagaStore.Entry<S>)this.sagaCache.get((Object)sagaIdentifier);
        if (saga == null && (saga = this.delegate.loadSaga(sagaType, sagaIdentifier)) != null) {
            this.sagaCache.put((Object)sagaIdentifier, new CacheEntry(saga));
        }
        return saga;
    }

    @Override
    public void insertSaga(Class<? extends T> sagaType, String sagaIdentifier, T saga, Set<AssociationValue> associationValues) {
        this.delegate.insertSaga(sagaType, sagaIdentifier, (T)saga, associationValues);
        this.sagaCache.put((Object)sagaIdentifier, new CacheEntry<T>(saga, associationValues));
        this.addCachedAssociations(associationValues, sagaIdentifier, sagaType);
    }

    @Override
    public void deleteSaga(Class<? extends T> sagaType, String sagaIdentifier, Set<AssociationValue> associationValues) {
        this.sagaCache.remove((Object)sagaIdentifier);
        associationValues.forEach(av -> this.removeAssociationValueFromCache(sagaType, sagaIdentifier, (AssociationValue)av));
        this.delegate.deleteSaga(sagaType, sagaIdentifier, associationValues);
    }

    private void removeAssociationValueFromCache(Class<?> sagaType, String sagaIdentifier, AssociationValue associationValue) {
        String key = this.cacheKey(associationValue, sagaType);
        this.associationsCache.computeIfPresent((Object)key, associations -> {
            ((Set)associations).remove(sagaIdentifier);
            return ((Set)associations).isEmpty() ? null : associations;
        });
    }

    protected void addCachedAssociations(Iterable<AssociationValue> associationValues, String sagaIdentifier, Class<?> sagaType) {
        for (AssociationValue associationValue : associationValues) {
            String key = this.cacheKey(associationValue, sagaType);
            this.associationsCache.computeIfPresent((Object)key, identifiers -> {
                ((Set)identifiers).add(sagaIdentifier);
                return identifiers;
            });
        }
    }

    @Override
    public void updateSaga(Class<? extends T> sagaType, String sagaIdentifier, T saga, AssociationValues associationValues) {
        this.sagaCache.put((Object)sagaIdentifier, new CacheEntry<T>(saga, associationValues.asSet()));
        this.delegate.updateSaga(sagaType, sagaIdentifier, (T)saga, associationValues);
        associationValues.removedAssociations().forEach(av -> this.removeAssociationValueFromCache(sagaType, sagaIdentifier, (AssociationValue)av));
        this.addCachedAssociations(associationValues.addedAssociations(), sagaIdentifier, sagaType);
    }

    private String cacheKey(AssociationValue associationValue, Class<?> sagaType) {
        return sagaType.getName() + "/" + associationValue.getKey() + "=" + associationValue.getValue();
    }

    private static class CacheEntry<T>
    implements SagaStore.Entry<T>,
    Serializable {
        private final T saga;
        private final Set<AssociationValue> associationValues;

        public CacheEntry(T saga, Set<AssociationValue> associationValues) {
            this.saga = saga;
            this.associationValues = associationValues;
        }

        public <S extends T> CacheEntry(SagaStore.Entry<S> other) {
            this.saga = other.saga();
            this.associationValues = other.associationValues();
        }

        @Override
        public Set<AssociationValue> associationValues() {
            return this.associationValues;
        }

        @Override
        public T saga() {
            return this.saga;
        }
    }

    public static class Builder<T> {
        private SagaStore<T> delegateSagaStore;
        private Cache associationsCache;
        private Cache sagaCache;

        public Builder<T> delegateSagaStore(SagaStore<T> delegateSagaStore) {
            BuilderUtils.assertNonNull(delegateSagaStore, (String)"Delegate SagaStore may not be null");
            this.delegateSagaStore = delegateSagaStore;
            return this;
        }

        public Builder<T> associationsCache(Cache associationsCache) {
            BuilderUtils.assertNonNull((Object)associationsCache, (String)"AssociationsCache may not be null");
            this.associationsCache = associationsCache;
            return this;
        }

        public Builder<T> sagaCache(Cache sagaCache) {
            BuilderUtils.assertNonNull((Object)sagaCache, (String)"SagaCache may not be null");
            this.sagaCache = sagaCache;
            return this;
        }

        public CachingSagaStore<T> build() {
            return new CachingSagaStore(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.delegateSagaStore, (String)"The delegate SagaStore is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.associationsCache, (String)"The associationsCache is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.sagaCache, (String)"The sagaCache is a hard requirement and should be provided");
        }
    }
}

