/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository.jpa;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.AssociationValues;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.modelling.saga.repository.jpa.AbstractSagaEntry;
import org.axonframework.modelling.saga.repository.jpa.AssociationValueEntry;
import org.axonframework.modelling.saga.repository.jpa.SagaEntry;
import org.axonframework.modelling.saga.repository.jpa.SerializedSaga;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaSagaStore
implements SagaStore<Object> {
    private static final Logger logger = LoggerFactory.getLogger(JpaSagaStore.class);
    private final String LOAD_SAGA_QUERY = "SELECT new " + this.serializedObjectType().getName() + "(se.serializedSaga, se.sagaType, se.revision) FROM " + this.sagaEntryEntityName() + " se WHERE se.sagaId = :sagaId";
    private final String DELETE_SAGA_QUERY = "DELETE FROM " + this.sagaEntryEntityName() + " se WHERE se.sagaId = :id";
    private final String UPDATE_SAGA_QUERY = "UPDATE " + this.sagaEntryEntityName() + " s SET s.serializedSaga = :serializedSaga, s.revision = :revision WHERE s.sagaId = :sagaId";
    private static final String DELETE_ASSOCIATION_QUERY = "DELETE FROM AssociationValueEntry ae WHERE ae.associationKey = :associationKey AND ae.associationValue = :associationValue AND ae.sagaType = :sagaType AND ae.sagaId = :sagaId";
    private static final String FIND_ASSOCIATION_IDS_QUERY = "SELECT ae.sagaId FROM AssociationValueEntry ae WHERE ae.associationKey = :associationKey AND ae.associationValue = :associationValue AND ae.sagaType = :sagaType";
    private static final String FIND_ASSOCIATIONS_QUERY = "SELECT ae FROM AssociationValueEntry ae WHERE ae.sagaType = :sagaType AND ae.sagaId = :sagaId";
    private static final String DELETE_ASSOCIATIONS_QUERY = "DELETE FROM AssociationValueEntry ae WHERE ae.sagaId = :sagaId";
    private static final String LOAD_SAGA_NAMED_QUERY = "LOAD_SAGA_NAMED_QUERY";
    private static final String DELETE_ASSOCIATION_NAMED_QUERY = "DELETE_ASSOCIATION_NAMED_QUERY";
    private static final String FIND_ASSOCIATION_IDS_NAMED_QUERY = "FIND_ASSOCIATION_IDS_NAMED_QUERY";
    private static final String FIND_ASSOCIATIONS_NAMED_QUERY = "FIND_ASSOCIATIONS_NAMED_QUERY";
    private static final String DELETE_ASSOCIATIONS_NAMED_QUERY = "DELETE_ASSOCIATIONS_NAMED_QUERY";
    private static final String DELETE_SAGA_NAMED_QUERY = "DELETE_SAGA_NAMED_QUERY";
    private static final String UPDATE_SAGA_NAMED_QUERY = "UPDATE_SAGA_NAMED_QUERY";
    private final EntityManagerProvider entityManagerProvider;
    private final Serializer serializer;
    private volatile boolean useExplicitFlush = true;

    protected JpaSagaStore(Builder builder) {
        builder.validate();
        this.entityManagerProvider = builder.entityManagerProvider;
        this.serializer = (Serializer)builder.serializer.get();
        this.addNamedQueriesTo(this.entityManagerProvider.getEntityManager());
    }

    public static Builder builder() {
        return new Builder();
    }

    private void addNamedQueriesTo(EntityManager entityManager) {
        EntityManagerFactory entityManagerFactory = entityManager.getEntityManagerFactory();
        entityManagerFactory.addNamedQuery(LOAD_SAGA_NAMED_QUERY, entityManager.createQuery(this.LOAD_SAGA_QUERY));
        entityManagerFactory.addNamedQuery(DELETE_ASSOCIATION_NAMED_QUERY, entityManager.createQuery(DELETE_ASSOCIATION_QUERY));
        entityManagerFactory.addNamedQuery(FIND_ASSOCIATION_IDS_NAMED_QUERY, entityManager.createQuery(FIND_ASSOCIATION_IDS_QUERY));
        entityManagerFactory.addNamedQuery(DELETE_ASSOCIATIONS_NAMED_QUERY, entityManager.createQuery(DELETE_ASSOCIATIONS_QUERY));
        entityManagerFactory.addNamedQuery(FIND_ASSOCIATIONS_NAMED_QUERY, entityManager.createQuery(FIND_ASSOCIATIONS_QUERY));
        entityManagerFactory.addNamedQuery(DELETE_SAGA_NAMED_QUERY, entityManager.createQuery(this.DELETE_SAGA_QUERY));
        entityManagerFactory.addNamedQuery(UPDATE_SAGA_NAMED_QUERY, entityManager.createQuery(this.UPDATE_SAGA_QUERY));
    }

    @Override
    public <S> SagaStore.Entry<S> loadSaga(Class<S> sagaType, String sagaIdentifier) {
        Class<? extends SimpleSerializedObject<?>> serializedObjectType;
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        List serializedSagaList = entityManager.createNamedQuery(LOAD_SAGA_NAMED_QUERY, serializedObjectType = this.serializedObjectType()).setParameter("sagaId", (Object)sagaIdentifier).setMaxResults(1).getResultList();
        if (serializedSagaList == null || serializedSagaList.isEmpty()) {
            return null;
        }
        SimpleSerializedObject serializedSaga = (SimpleSerializedObject)serializedSagaList.get(0);
        Object loadedSaga = this.serializer.deserialize((SerializedObject)serializedSaga);
        Set<AssociationValue> associationValues = this.loadAssociationValues(entityManager, sagaType, sagaIdentifier);
        if (logger.isDebugEnabled()) {
            logger.debug("Loaded saga id [{}] of type [{}]", (Object)sagaIdentifier, (Object)serializedSaga.getType().getName());
        }
        return new EntryImpl<Object>(associationValues, loadedSaga);
    }

    protected Set<AssociationValue> loadAssociationValues(EntityManager entityManager, Class<?> sagaType, String sagaIdentifier) {
        List associationValueEntries = entityManager.createNamedQuery(FIND_ASSOCIATIONS_NAMED_QUERY, AssociationValueEntry.class).setParameter("sagaType", (Object)this.getSagaTypeName(sagaType)).setParameter("sagaId", (Object)sagaIdentifier).getResultList();
        return associationValueEntries.stream().map(AssociationValueEntry::getAssociationValue).collect(Collectors.toCollection(HashSet::new));
    }

    protected void removeAssociationValue(EntityManager entityManager, Class<?> sagaType, String sagaIdentifier, AssociationValue associationValue) {
        int updateCount = entityManager.createNamedQuery(DELETE_ASSOCIATION_NAMED_QUERY).setParameter("associationKey", (Object)associationValue.getKey()).setParameter("associationValue", (Object)associationValue.getValue()).setParameter("sagaType", (Object)this.getSagaTypeName(sagaType)).setParameter("sagaId", (Object)sagaIdentifier).executeUpdate();
        if (updateCount == 0 && logger.isWarnEnabled()) {
            logger.warn("Wanted to remove association value, but it was already gone: sagaId= {}, key={}, value={}", new Object[]{sagaIdentifier, associationValue.getKey(), associationValue.getValue()});
        }
    }

    protected void storeAssociationValue(EntityManager entityManager, Class<?> sagaType, String sagaIdentifier, AssociationValue associationValue) {
        entityManager.persist((Object)new AssociationValueEntry(this.getSagaTypeName(sagaType), sagaIdentifier, associationValue));
    }

    private String getSagaTypeName(Class<?> sagaType) {
        return this.serializer.typeForClass(sagaType).getName();
    }

    @Override
    public Set<String> findSagas(Class<?> sagaType, AssociationValue associationValue) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        List entries = entityManager.createNamedQuery(FIND_ASSOCIATION_IDS_NAMED_QUERY, String.class).setParameter("associationKey", (Object)associationValue.getKey()).setParameter("associationValue", (Object)associationValue.getValue()).setParameter("sagaType", (Object)this.getSagaTypeName(sagaType)).getResultList();
        return new TreeSet<String>(entries);
    }

    @Override
    public void deleteSaga(Class<?> sagaType, String sagaIdentifier, Set<AssociationValue> associationValues) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        try {
            entityManager.createNamedQuery(DELETE_ASSOCIATIONS_NAMED_QUERY).setParameter("sagaId", (Object)sagaIdentifier).executeUpdate();
            entityManager.createNamedQuery(DELETE_SAGA_NAMED_QUERY).setParameter("id", (Object)sagaIdentifier).executeUpdate();
        }
        catch (EntityNotFoundException e) {
            logger.info("Could not delete {} {}, it appears to have already been deleted.", (Object)this.sagaEntryEntityName(), (Object)sagaIdentifier);
        }
        if (this.useExplicitFlush) {
            entityManager.flush();
        }
    }

    @Override
    public void updateSaga(Class<?> sagaType, String sagaIdentifier, Object saga, AssociationValues associationValues) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        AbstractSagaEntry<?> entry = this.createSagaEntry(saga, sagaIdentifier, this.serializer);
        if (logger.isDebugEnabled()) {
            logger.debug("Updating saga id {} as {}", (Object)sagaIdentifier, (Object)this.serializedSagaAsString(entry));
        }
        int updateCount = entityManager.createNamedQuery(UPDATE_SAGA_NAMED_QUERY).setParameter("serializedSaga", entry.getSerializedSaga()).setParameter("revision", (Object)entry.getRevision()).setParameter("sagaId", (Object)entry.getSagaId()).executeUpdate();
        for (AssociationValue associationValue : associationValues.addedAssociations()) {
            this.storeAssociationValue(entityManager, sagaType, sagaIdentifier, associationValue);
        }
        for (AssociationValue associationValue : associationValues.removedAssociations()) {
            this.removeAssociationValue(entityManager, sagaType, sagaIdentifier, associationValue);
        }
        if (updateCount == 0) {
            logger.warn("Expected to be able to update a Saga instance, but no rows were found.");
        }
        if (this.useExplicitFlush) {
            entityManager.flush();
        }
    }

    private String serializedSagaAsString(AbstractSagaEntry<?> entry) {
        if (entry instanceof SagaEntry) {
            return new String((byte[])entry.getSerializedSaga(), Charset.forName("UTF-8"));
        }
        return "[Custom serialization format (not visible)]";
    }

    @Override
    public void insertSaga(Class<?> sagaType, String sagaIdentifier, Object saga, Set<AssociationValue> associationValues) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        AbstractSagaEntry<?> entry = this.createSagaEntry(saga, sagaIdentifier, this.serializer);
        entityManager.persist(entry);
        for (AssociationValue associationValue : associationValues) {
            this.storeAssociationValue(entityManager, sagaType, sagaIdentifier, associationValue);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Storing saga id {} as {}", (Object)sagaIdentifier, (Object)this.serializedSagaAsString(entry));
        }
        if (this.useExplicitFlush) {
            entityManager.flush();
        }
    }

    public void setUseExplicitFlush(boolean useExplicitFlush) {
        this.useExplicitFlush = useExplicitFlush;
    }

    protected AbstractSagaEntry<?> createSagaEntry(Object saga, String sagaIdentifier, Serializer serializer) {
        return new SagaEntry<Object>(saga, sagaIdentifier, serializer);
    }

    protected String sagaEntryEntityName() {
        return SagaEntry.class.getSimpleName();
    }

    protected Class<? extends SimpleSerializedObject<?>> serializedObjectType() {
        return SerializedSaga.class;
    }

    private static class EntryImpl<S>
    implements SagaStore.Entry<S> {
        private final Set<AssociationValue> associationValues;
        private final S loadedSaga;

        public EntryImpl(Set<AssociationValue> associationValues, S loadedSaga) {
            this.associationValues = associationValues;
            this.loadedSaga = loadedSaga;
        }

        @Override
        public Set<AssociationValue> associationValues() {
            return this.associationValues;
        }

        @Override
        public S saga() {
            return this.loadedSaga;
        }
    }

    public static class Builder {
        private EntityManagerProvider entityManagerProvider;
        private Supplier<Serializer> serializer;

        public Builder entityManagerProvider(EntityManagerProvider entityManagerProvider) {
            BuilderUtils.assertNonNull((Object)entityManagerProvider, (String)"EntityManagerProvider may not be null");
            this.entityManagerProvider = entityManagerProvider;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull((Object)serializer, (String)"Serializer may not be null");
            this.serializer = () -> serializer;
            return this;
        }

        public JpaSagaStore build() {
            return new JpaSagaStore(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.entityManagerProvider, (String)"The EntityManagerProvider is a hard requirement and should be provided");
            if (this.serializer == null) {
                logger.warn("The default XStreamSerializer is used, whereas it is strongly recommended to configure the security context of the XStream instance.", (Throwable)new AxonConfigurationException("A default XStreamSerializer is used, without specifying the security context"));
                this.serializer = XStreamSerializer::defaultSerializer;
            }
        }
    }
}

