/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.NullLockFactory;
import org.axonframework.eventhandling.DomainEventSequenceAware;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.modelling.command.AggregateNotFoundException;
import org.axonframework.modelling.command.LockingRepository;
import org.axonframework.modelling.command.RepositoryProvider;
import org.axonframework.modelling.command.RepositorySpanFactory;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregate;
import org.axonframework.tracing.SpanFactory;

public class GenericJpaRepository<T>
extends LockingRepository<T, AnnotatedAggregate<T>> {
    private final EntityManagerProvider entityManagerProvider;
    private final EventBus eventBus;
    private final RepositoryProvider repositoryProvider;
    private final Function<String, ?> identifierConverter;
    private final boolean generateSequenceNumbers;
    private boolean forceFlushOnSave = true;

    public static <T> Builder<T> builder(Class<T> aggregateType) {
        return new Builder<T>(aggregateType);
    }

    protected GenericJpaRepository(Builder<T> builder) {
        super(builder);
        this.entityManagerProvider = ((Builder)builder).entityManagerProvider;
        this.eventBus = ((Builder)builder).eventBus;
        this.identifierConverter = ((Builder)builder).identifierConverter;
        this.repositoryProvider = ((Builder)builder).repositoryProvider;
        this.generateSequenceNumbers = ((Builder)builder).generateSequenceNumbers;
    }

    @Override
    protected AnnotatedAggregate<T> doLoadWithLock(String aggregateIdentifier, Long expectedVersion) {
        Object aggregateRoot = this.entityManagerProvider.getEntityManager().find(this.getAggregateType(), this.identifierConverter.apply(aggregateIdentifier), LockModeType.PESSIMISTIC_WRITE);
        if (aggregateRoot == null) {
            throw new AggregateNotFoundException(aggregateIdentifier, String.format("Aggregate [%s] with identifier [%s] not found", this.getAggregateType().getSimpleName(), aggregateIdentifier));
        }
        AnnotatedAggregate<Object> aggregate = AnnotatedAggregate.initialize(aggregateRoot, this.aggregateModel(), this.eventBus, this.repositoryProvider);
        if (this.shouldGenerateSequences()) {
            Optional sequenceNumber = ((DomainEventSequenceAware)this.eventBus).lastSequenceNumberFor(aggregateIdentifier);
            sequenceNumber.ifPresent(aggregate::initSequence);
        }
        return aggregate;
    }

    @Override
    protected AnnotatedAggregate<T> doCreateNewForLock(Callable<T> factoryMethod) throws Exception {
        return AnnotatedAggregate.initialize(factoryMethod, this.aggregateModel(), this.eventBus, this.repositoryProvider, this.shouldGenerateSequences());
    }

    private boolean shouldGenerateSequences() {
        return this.eventBus instanceof DomainEventSequenceAware && this.generateSequenceNumbers;
    }

    @Override
    protected void doSaveWithLock(AnnotatedAggregate<T> aggregate) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        entityManager.persist(aggregate.getAggregateRoot());
        if (this.forceFlushOnSave) {
            entityManager.flush();
        }
    }

    @Override
    protected void doDeleteWithLock(AnnotatedAggregate<T> aggregate) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        entityManager.remove(aggregate.getAggregateRoot());
        if (this.forceFlushOnSave) {
            entityManager.flush();
        }
    }

    public void setForceFlushOnSave(boolean forceFlushOnSave) {
        this.forceFlushOnSave = forceFlushOnSave;
    }

    public static class Builder<T>
    extends LockingRepository.Builder<T> {
        private EntityManagerProvider entityManagerProvider;
        private EventBus eventBus;
        private RepositoryProvider repositoryProvider;
        private Function<String, ?> identifierConverter = Function.identity();
        private boolean generateSequenceNumbers = true;

        protected Builder(Class<T> aggregateType) {
            super(aggregateType);
            super.lockFactory((LockFactory)NullLockFactory.INSTANCE);
        }

        @Override
        public Builder<T> parameterResolverFactory(@Nonnull ParameterResolverFactory parameterResolverFactory) {
            super.parameterResolverFactory(parameterResolverFactory);
            return this;
        }

        @Override
        public Builder<T> handlerDefinition(@Nonnull HandlerDefinition handlerDefinition) {
            super.handlerDefinition(handlerDefinition);
            return this;
        }

        @Override
        public Builder<T> aggregateModel(@Nonnull AggregateModel<T> aggregateModel) {
            super.aggregateModel((AggregateModel)aggregateModel);
            return this;
        }

        @Override
        public Builder<T> lockFactory(LockFactory lockFactory) {
            super.lockFactory(lockFactory);
            return this;
        }

        @Override
        public Builder<T> subtypes(@Nonnull Set<Class<? extends T>> subtypes) {
            super.subtypes((Set)subtypes);
            return this;
        }

        @Override
        public Builder<T> subtype(@Nonnull Class<? extends T> subtype) {
            super.subtype((Class)subtype);
            return this;
        }

        @Override
        @Deprecated
        public Builder<T> spanFactory(SpanFactory spanFactory) {
            super.spanFactory(spanFactory);
            return this;
        }

        @Override
        public Builder<T> spanFactory(RepositorySpanFactory spanFactory) {
            super.spanFactory(spanFactory);
            return this;
        }

        public Builder<T> entityManagerProvider(EntityManagerProvider entityManagerProvider) {
            BuilderUtils.assertNonNull((Object)entityManagerProvider, (String)"EntityManagerProvider may not be null");
            this.entityManagerProvider = entityManagerProvider;
            return this;
        }

        public Builder<T> eventBus(EventBus eventBus) {
            BuilderUtils.assertNonNull((Object)eventBus, (String)"EventBus may not be null");
            this.eventBus = eventBus;
            return this;
        }

        public Builder<T> repositoryProvider(RepositoryProvider repositoryProvider) {
            this.repositoryProvider = repositoryProvider;
            return this;
        }

        public Builder<T> identifierConverter(Function<String, ?> identifierConverter) {
            BuilderUtils.assertNonNull(identifierConverter, (String)"The identifierConverter may not be null");
            this.identifierConverter = identifierConverter;
            return this;
        }

        public Builder<T> disableSequenceNumberGeneration() {
            this.generateSequenceNumbers = false;
            return this;
        }

        public GenericJpaRepository<T> build() {
            return new GenericJpaRepository(this);
        }

        @Override
        protected void validate() {
            super.validate();
            BuilderUtils.assertNonNull((Object)this.entityManagerProvider, (String)"The EntityManagerProvider is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.eventBus, (String)"The EventBus is a hard requirement and should be provided");
        }
    }
}

