/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import org.axonframework.common.BuilderUtils;
import org.axonframework.modelling.command.RepositorySpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;

public class DefaultRepositorySpanFactory
implements RepositorySpanFactory {
    private final SpanFactory spanFactory;
    private final String aggregateIdAttribute;

    protected DefaultRepositorySpanFactory(Builder builder) {
        builder.validate();
        this.spanFactory = builder.builderSpanFactory;
        this.aggregateIdAttribute = builder.builderAggregateIdAttribute;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Span createLoadSpan(String aggregateId) {
        return this.spanFactory.createInternalSpan(() -> "Repository.load").addAttribute(this.aggregateIdAttribute, aggregateId);
    }

    @Override
    public Span createObtainLockSpan(String aggregateId) {
        return this.spanFactory.createInternalSpan(() -> "Repository.obtainLock").addAttribute(this.aggregateIdAttribute, aggregateId);
    }

    @Override
    public Span createInitializeStateSpan(String aggregateType, String aggregateId) {
        return this.spanFactory.createInternalSpan(() -> "Repository.initializeState(" + aggregateType + ")").addAttribute(this.aggregateIdAttribute, aggregateId);
    }

    public static class Builder {
        private SpanFactory builderSpanFactory;
        private String builderAggregateIdAttribute = "axon.aggregateId";

        public Builder spanFactory(SpanFactory spanFactory) {
            BuilderUtils.assertNonNull((Object)spanFactory, (String)"spanFactory may not be null");
            this.builderSpanFactory = spanFactory;
            return this;
        }

        public Builder aggregateIdAttribute(String aggregateIdAttribute) {
            BuilderUtils.assertNonEmpty((String)aggregateIdAttribute, (String)"aggregateIdAttribute may not be null");
            this.builderAggregateIdAttribute = aggregateIdAttribute;
            return this;
        }

        protected void validate() {
            BuilderUtils.assertNonNull((Object)this.builderSpanFactory, (String)"spanFactory may not be null");
        }

        public DefaultRepositorySpanFactory build() {
            return new DefaultRepositorySpanFactory(this);
        }
    }
}

