/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.axonframework.messaging.Message;
import org.axonframework.modelling.command.AggregateMember;
import org.axonframework.modelling.command.ForwardingMode;
import org.axonframework.modelling.command.inspection.EntityModel;

public class ForwardMatchingInstances<T extends Message<?>>
implements ForwardingMode<T> {
    private static final String EMPTY_STRING = "";
    private static final Property<Object> NO_PROPERTY = new NoProperty();
    private final Map<Class, Property> routingProperties = new ConcurrentHashMap<Class, Property>();
    private String routingKey;
    private EntityModel childEntity;

    @Override
    public void initialize(@Nonnull Member member, @Nonnull EntityModel childEntity) {
        this.childEntity = childEntity;
        this.routingKey = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)((AnnotatedElement)((Object)member)), AggregateMember.class).map(map -> (String)map.get("routingKey")).filter(key -> !Objects.equals(key, EMPTY_STRING)).orElse(childEntity.routingKey());
        this.routingProperties.clear();
    }

    @Override
    public <E> Stream<E> filterCandidates(@Nonnull T message, @Nonnull Stream<E> candidates) {
        Property routingProperty = this.routingProperties.computeIfAbsent(message.getPayloadType(), this::resolveProperty);
        if (routingProperty == null || routingProperty == NO_PROPERTY) {
            return Stream.empty();
        }
        Object routingValue = routingProperty.getValue(message.getPayload());
        return candidates.filter(candidate -> this.matchesInstance(candidate, routingValue));
    }

    private Property<?> resolveProperty(Class<?> runtimeType) {
        Property property = PropertyAccessStrategy.getProperty(runtimeType, (String)this.routingKey);
        if (property == null) {
            return NO_PROPERTY;
        }
        return property;
    }

    private <E> boolean matchesInstance(E candidate, Object routingValue) {
        Object identifier = this.childEntity.getIdentifier(candidate);
        return Objects.equals(routingValue, identifier);
    }

    private static class NoProperty
    implements Property<Object> {
        private NoProperty() {
        }

        public <V> V getValue(Object target) {
            throw new UnsupportedOperationException("Property not found on target");
        }
    }
}

